/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.proalpha.pds.generator.ContentGenerator;
import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.paconnector.repository.Instance;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OOABLInterfaceFileGenerator {
    private static final String STANDARD_INTERFACE_SUFFIX = "Std.cls";
    private static final String EMPTY_STRING = "";
    private static final String INTERFACE_SUFFIX = ".cls";
    private static final String CUSTOM_INTERFACE_SUFFIX_PATTERN = "Std.cls|[C,U,Q,X,Y].cls|.cls";
    private static final String OOABL_STD_PARENTCLASS = "OOABL";
    private final IGeneratorDataContainer dataContrainer;
    private String templateGeneratorName;
    private final RepositoryDelegate repositoryDelegate;
    private final RepositoryInformations repositoryInformations;

    public OOABLInterfaceFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName, RepositoryDelegate repositoryDelegate, RepositoryInformations repositoryInformations) {
        this.dataContrainer = datacontainer;
        this.templateGeneratorName = templateGeneratorName;
        this.repositoryDelegate = repositoryDelegate;
        this.repositoryInformations = repositoryInformations;
        this.initializeGenerator();
    }

    private void createObjectInRepository(String parentClass, String fileName, String description) {
        try {
            Instance instance = this.repositoryDelegate.getEmptyInstance();
            instance.setName(fileName);
            instance.setShortDescription(description);
            instance.setParentClass(parentClass);
            this.repositoryDelegate.createRepositoryEntryforInstance(instance);
        }
        catch (Exception e) {
            this.showErrorMessage("Unable to create File in the Repository", e.getMessage());
        }
    }

    private String getParentObjectFromStandardClass(String standardClass) {
        String parentClass = null;
        if (standardClass != null && standardClass.equals(EMPTY_STRING)) {
            parentClass = this.repositoryInformations.getClassName(this.repositoryInformations.getClassOBJ(standardClass));
        }
        if (parentClass == null || parentClass.equals(EMPTY_STRING)) {
            parentClass = OOABL_STD_PARENTCLASS;
        }
        return parentClass;
    }

    private String getClassName(String fileName) {
        return fileName.replace(INTERFACE_SUFFIX, EMPTY_STRING);
    }

    private String getDescription(String fileName) {
        String description = this.isStandardCustomLevel(this.dataContrainer.getCustomLevel()) ? "Standard Interface for " + fileName : "Custom Interface for " + fileName;
        return description;
    }

    private String getFileName(String mainClassName, String currentCustomLevel) {
        String suffix = this.isStandardCustomLevel(currentCustomLevel) ? STANDARD_INTERFACE_SUFFIX : String.valueOf(currentCustomLevel) + INTERFACE_SUFFIX;
        return mainClassName.concat(suffix);
    }

    private String getMainClassName(String fileName) {
        return fileName.replaceAll(CUSTOM_INTERFACE_SUFFIX_PATTERN, EMPTY_STRING);
    }

    private String getQualifiedClassName(String className) {
        String packagePath = this.dataContrainer.getRelativePath().replace("/", ".");
        String classNameWithoutSuffix = className.replaceAll(INTERFACE_SUFFIX, EMPTY_STRING);
        return classNameWithoutSuffix.equals(EMPTY_STRING) ? classNameWithoutSuffix : String.valueOf(packagePath) + "." + classNameWithoutSuffix;
    }

    private String getStandardClassIfAvailable(String mainClassName) {
        String standardClass = mainClassName.concat(STANDARD_INTERFACE_SUFFIX);
        return this.isInRepository(standardClass) != false ? standardClass : EMPTY_STRING;
    }

    private String getXBaseName(String fileName) {
        return fileName.replace(".", "_");
    }

    private Boolean isInRepository(String className) {
        return this.repositoryInformations.exitsInstanceInRepository(className);
    }

    private boolean isStandardCustomLevel(String currentCustomLevel) {
        return CustomLevel.STANDARD.getValue().equals(currentCustomLevel);
    }

    private void initializeGenerator() {
        String currentCustomLevel = this.dataContrainer.getCustomLevel();
        String mainClassName = this.getMainClassName(this.dataContrainer.getFileName());
        this.dataContrainer.setMainClass(mainClassName);
        String fileName = this.getFileName(mainClassName, currentCustomLevel);
        this.dataContrainer.setFileName(fileName);
        String xbaseName = this.getXBaseName(fileName);
        this.dataContrainer.setXBaseName(xbaseName);
        String className = this.getClassName(fileName);
        String qualifiedClassName = this.getQualifiedClassName(className);
        this.dataContrainer.setQualifiedClassName(qualifiedClassName);
        String standardClassName = this.getStandardClassIfAvailable(mainClassName);
        String qualifiedStandardClassName = this.getQualifiedClassName(standardClassName);
        this.dataContrainer.setQualifiedClassStandardClassName(qualifiedStandardClassName);
        String descriptionClassName = !standardClassName.isEmpty() ? standardClassName : String.valueOf(mainClassName) + INTERFACE_SUFFIX;
        String description = this.getDescription(descriptionClassName);
        this.dataContrainer.setDescription(description);
        if (this.dataContrainer.getParentObject().equals(EMPTY_STRING)) {
            String parentObject = this.getParentObjectFromStandardClass(standardClassName);
            this.dataContrainer.setParentObject(parentObject);
        }
    }

    private void showErrorMessage(String title, String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    public void generate() throws Exception {
        if (!this.isInRepository(this.dataContrainer.getFileName()).booleanValue()) {
            this.createObjectInRepository(this.dataContrainer.getParentObject(), this.dataContrainer.getFileName(), this.dataContrainer.getDescription());
        }
        ContentGenerator generator = new ContentGenerator("OOABL Class Generator", this.dataContrainer, this.templateGeneratorName);
        generator.schedule();
        IJobManager jobManager = Job.getJobManager();
        jobManager.join((Object)"com.proalpha.java.oea.plugins.generator.AbstractGenerator", (IProgressMonitor)new NullProgressMonitor());
    }

    public void generateUserExitClassAndBalpEntry() throws Exception {
        this.generate();
        GeneratorFactory generatorFactory = new GeneratorFactory();
        generatorFactory.createBalpGenerator(this.dataContrainer).generate();
    }

    private static enum CustomLevel {
        STANDARD(""),
        COUNTRY("C"),
        INDUSTRY("U"),
        COMPONENT("Q"),
        PARTNER("X"),
        CUSTOMER("Y"),
        NOVALUE("NOVALUE");

        private String value;

        private CustomLevel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

