/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.RunCommonPaProgram;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.ui.AbstractProAlphaHandler;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;

public class OpenRepositoryClassesHandler
extends AbstractProAlphaHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IOpenEdgeProject currProj = this.getOeProjectOfEvent(event);
            String fileName = this.getOeFileOfEvent(event);
            OpenRepositoryClassesHandler.runProgram(currProj, fileName);
        }
        catch (ProALPHANotAvailableException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        return null;
    }

    private static void runProgram(final IOpenEdgeProject oeProject, final String fileName) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Open Repository Classes", 2);
                monitor.worked(1);
                RunCommonPaProgram paProgram = new RunCommonPaProgram(oeProject);
                String fileObjectId = "DRC_Instance_Obj=" + paProgram.getInstanceObj(fileName);
                paProgram.startRepositoryClasses(fileObjectId);
                monitor.done();
            }
        };
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)rule);
        }
        catch (InterruptedException | InvocationTargetException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
    }
}

