/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProjectPlugin;
import com.proalpha.pds.paconnector.RunCommonPaProgram;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;

public class UserExitGeneratorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = null;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structSelect = (IStructuredSelection)selection;
        Object firstElement = structSelect.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return null;
        }
        if (firstElement instanceof IResource) {
            IResource res = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class);
            project = res.getProject();
        }
        if (firstElement instanceof IProject) {
            project = (IProject)((IAdaptable)firstElement).getAdapter(IProject.class);
        }
        if (project == null) {
            return null;
        }
        IOpenEdgeProject currProj = OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject(project);
        IAVMClient runtime = currProj.getRuntime();
        if (runtime != null) {
            UserExitGeneratorHandler.runProgram(currProj);
        }
        return null;
    }

    private static void runProgram(final IOpenEdgeProject oeProject) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Open Procedure Viewer", 2);
                monitor.worked(1);
                RunCommonPaProgram mainMenu = new RunCommonPaProgram(oeProject);
                mainMenu.startShowPersistenProcedure();
                monitor.done();
            }
        };
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)rule);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

