/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.generator.UserExitFileGenerator;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.Activator;
import com.proalpha.pds.ui.ProgressServiceUtil;
import com.proalpha.pds.ui.ProjectFinder;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UserExitGeneratorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        OEProject currProj = ProjectFinder.getOEProjectByTextSelection();
        IAVMClient runtime = currProj.getRuntime();
        if (runtime != null) {
            this.generateUserExits((IOpenEdgeProject)currProj);
        }
        return null;
    }

    private void generateUserExits(final IOpenEdgeProject openEdgeProject) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    IGeneratorDataContainer datacontainer = DataContainerFactory.createDataContainer();
                    RunProgramInPa paBridge = new RunProgramInPa(openEdgeProject);
                    StartparameterReader pAStartParam = ParameterFactory.createStartparameterReader((OEProject)((OEProject)openEdgeProject));
                    String pAProcedure = ProjectFinder.getCurrentFileFromEditor().getName();
                    datacontainer.setFileName(pAProcedure);
                    datacontainer.setVersion(paBridge.getProALPHAVersion());
                    datacontainer.setCustomLevel(paBridge.getpAStartupParam("customlevel", ""));
                    datacontainer.setObjectInfo(datacontainer.getRepositoryInformations().getProgramShortDesc(pAProcedure));
                    if (pAProcedure.endsWith(".cls")) {
                        String pAParentClaasObj = datacontainer.getRepositoryInformations().getClassOBJ(pAProcedure);
                        datacontainer.setParentObject(datacontainer.getRepositoryInformations().getClassName(pAParentClaasObj));
                        OOABLExitFileGenerator gen = GeneratorFactory.createOOABLExitFileGenerator((IGeneratorDataContainer)datacontainer, (String)"pAOOABLStdClass");
                        gen.generateUserExitClassAndBalpEntry();
                    } else {
                        datacontainer.setParentObject(pAProcedure);
                        UserExitFileGenerator gen = GeneratorFactory.createUserExitFileGenerator((IGeneratorDataContainer)datacontainer);
                        gen.generateUserExitClassAndBalpEntry();
                    }
                    Job.getJobManager().join((Object)"com.proalpha.java.oea.plugins.generator.AbstractGenerator", (IProgressMonitor)new NullProgressMonitor());
                    pAStartParam.getWorkingDirectory().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)exception);
                }
            }
        };
        ProgressServiceUtil.runInUI("Generate UserExit", runnable);
    }
}

