/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProjectPlugin;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AbstractProAlphaHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        throw new ExecutionException("AbstractProAlphaHandler must be extended by an existing proALPHA handler!");
    }

    public IOpenEdgeProject getOeProjectOfEvent(ExecutionEvent event) throws ProALPHANotAvailableException, ExecutionException {
        IResource resource;
        IProject project = null;
        Object firstElement = null;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection == null) {
            throw new ProALPHANotAvailableException("No pA-Selection found!");
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            firstElement = structuredSelection.getFirstElement();
        } else if (selection instanceof ITextSelection) {
            firstElement = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        } else {
            throw new ProALPHANotAvailableException("No pA-Resource selected!");
        }
        if (firstElement instanceof IResource) {
            IResource res = (IResource)firstElement;
            project = res.getProject();
        } else if (firstElement instanceof IFile) {
            IFile file = (IFile)firstElement;
            project = file.getProject();
        } else if (firstElement instanceof IAdaptable && (project = (IProject)((IAdaptable)firstElement).getAdapter(IProject.class)) == null && (resource = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class)) != null) {
            project = resource.getProject();
        }
        if (project == null) {
            throw new ProALPHANotAvailableException("Could not find current pA-project!");
        }
        IOpenEdgeProject currProj = OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject((IResource)project);
        IAVMClient runtime = currProj.getRuntime();
        if (runtime == null) {
            throw new ProALPHANotAvailableException("No pA-project runtime available!");
        }
        return currProj;
    }

    public String getOeFileOfEvent(ExecutionEvent event) throws ProALPHANotAvailableException, ExecutionException {
        IResource resource;
        String fileName = null;
        Object firstElement = null;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection == null) {
            throw new ProALPHANotAvailableException("No pA-Selection found!");
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            firstElement = structuredSelection.getFirstElement();
        } else if (selection instanceof ITextSelection) {
            firstElement = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        } else {
            throw new ProALPHANotAvailableException("No pA-Resource selected!");
        }
        if (firstElement instanceof IFile) {
            IFile file = (IFile)firstElement;
            fileName = file.getName();
        } else if (firstElement instanceof IAdaptable && (resource = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class)) != null) {
            fileName = resource.getName();
        }
        if (fileName == null) {
            throw new ProALPHANotAvailableException("No pA-File selected!");
        }
        return fileName;
    }
}

