/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.controller;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.generator.ContentGenerator;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.ProjectHandler;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryFactory;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPage;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import com.proalpha.pds.ui.wizards.wizardpages.WizardpageFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaWizard
extends Wizard {
    private final Logger logger = LoggerFactory.getLogger(PaWizard.class);
    protected ISelection selection;
    protected WizardMainPage wizardMainPage;
    private RunProgramInPa bridge;
    private LinkedHashMap<String, WizardMainPageConfiguration> configList;
    private RepositoryDelegate repositoryDelegate;
    private RepositoryInformations repositoryInformations;
    private StartparameterReader startparameterReader;
    protected Map<String, Object> wizardSettings;

    public PaWizard() {
        this.setNeedsProgressMonitor(true);
        ProjectHandler projectHandler = new ProjectHandler();
        if (!projectHandler.iscurrentProjectOpen()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"no active project.", (String)String.format("%s %s %s", "There current selected Project", projectHandler.getActiveProjectName(), "is not open."));
        }
        OEProject oeproject = projectHandler.getActiveOEProject();
        this.logger.debug("Running wizard for {}", (Object)oeproject);
        try {
            RepositoryFactory repositoryFactory = new RepositoryFactory();
            this.repositoryDelegate = repositoryFactory.createRepositoryDelegate((IOpenEdgeProject)oeproject);
            this.repositoryInformations = repositoryFactory.createRepositoryInformations(this.repositoryDelegate.getPaBridge());
            ParameterFactory parameterFactory = new ParameterFactory();
            this.startparameterReader = parameterFactory.createStartparameterReader(this.repositoryDelegate.getPaBridge());
            this.bridge = this.repositoryDelegate.getPaBridge();
        }
        catch (ProALPHANotAvailableException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        if (!this.bridge.isproALPHAAvailable()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Connect to version control failed", (String)"The version control is not available.");
            throw new IllegalStateException("Version control is not available");
        }
        this.wizardSettings = new HashMap<String, Object>();
    }

    protected boolean doFinish() {
        try {
            DataContainerFactory factory = new DataContainerFactory();
            ProjectHandler handler = new ProjectHandler();
            IGeneratorDataContainer dataContainer = factory.createDataContainer((IOpenEdgeProject)handler.getActiveOEProject(), this.wizardSettings);
            new ContentGenerator("", dataContainer, this.wizardSettings.get("TemplateName").toString()).schedule();
        }
        catch (Exception e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.proalpha.java.plugins.templates", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        IWizardPage[] wizardPages;
        IWizardPage[] iWizardPageArray = wizardPages = this.getPages();
        int n = wizardPages.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] interfaces;
            IWizardPage page = iWizardPageArray[n2];
            Class<?>[] classArray = interfaces = page.getClass().getInterfaces();
            int n3 = interfaces.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> c = classArray[n4];
                if (c.getName().contains("IpaWizardPage")) {
                    try {
                        Method method = page.getClass().getMethod("getSettings", new Class[0]);
                        this.wizardSettings.putAll((HashMap)method.invoke((Object)page, new Object[0]));
                    }
                    catch (Exception e) {
                        ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
                        return false;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return this.doFinish();
    }

    public void addPages() {
        this.wizardMainPage = WizardpageFactory.createWizardMainPage(this.configList, this.repositoryDelegate, this.repositoryInformations, this.startparameterReader);
        this.addPage((IWizardPage)this.wizardMainPage);
    }

    public RunProgramInPa getbridge() {
        return this.bridge;
    }

    public RepositoryDelegate getRepositoryDelegate() {
        return this.repositoryDelegate;
    }

    public RepositoryInformations getRepositoryInformations() {
        return this.repositoryInformations;
    }

    public StartparameterReader getStartparameterReader() {
        return this.startparameterReader;
    }

    public LinkedHashMap<String, WizardMainPageConfiguration> getConfigList() {
        return this.configList;
    }

    public void setConfigList(LinkedHashMap<String, WizardMainPageConfiguration> configList) {
        this.configList = configList;
    }
}

