/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public class RunUnitTestHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PaProject paProject = Activator.getDefault().getProjectManager().getPaProjectByTextSelection();
        RunProgramInPa runPaProgram = this.getPaProjectSessionRunContext(paProject);
        if (runPaProgram != null) {
            File runUnitTestProcedure = this.getRunUnitTestProcedureResource();
            File selectedUnitTestResource = this.getSelectedUnitTestResource();
            IPath outputDirectory = this.getOutputDirectory(paProject).makeAbsolute();
            if (runUnitTestProcedure != null && selectedUnitTestResource != null && outputDirectory != null) {
                runPaProgram.runExternalProcedure(runUnitTestProcedure.getAbsolutePath(), new String[]{selectedUnitTestResource.getAbsolutePath(), outputDirectory.toOSString()});
                this.openUnitTestResults(event, outputDirectory);
            }
        }
        return null;
    }

    private void openUnitTestResults(ExecutionEvent event, IPath outputDirectory) {
        IPath resultsXmlPath = outputDirectory.append("results.xml");
        IFileStore resultsXml = EFS.getLocalFileSystem().getStore(resultsXmlPath);
        IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        try {
            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)resultsXml);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error showing unit test results", (String)("There was an error trying to display the unit test results.\n" + String.format("Please open the test results in %s manually.", resultsXmlPath.toOSString())));
        }
    }

    private File getSelectedUnitTestResource() {
        File unitTestResource = null;
        IFolder resource = Activator.getDefault().getProjectManager().getFolderFromActiveSelection();
        if (resource == null) {
            resource = Activator.getDefault().getProjectManager().getFileFromActiveSelection();
        }
        if (resource != null) {
            unitTestResource = resource.getRawLocation().makeAbsolute().toFile();
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No resource selected", (String)"There is no unit test file / folder selected");
        }
        return unitTestResource;
    }

    private IPath getOutputDirectory(PaProject paProject) {
        Path outputDirectory = null;
        String tempDirectory = paProject.getBridge().getpAStartupParam("temp", "");
        if (tempDirectory != null && !tempDirectory.isEmpty()) {
            outputDirectory = new Path(tempDirectory);
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No temp directory available", (String)"Could not read temp direcotry from the current proALPHA session!");
        }
        return outputDirectory;
    }

    private File getRunUnitTestProcedureResource() {
        File procedure = null;
        try {
            Bundle bundle = Platform.getBundle((String)"com.proalpha.pds.ui");
            Path UnitTestprocedurePath = new Path("resources/unittest/runAblUnitFromPDS.p");
            URL procedureLocation = FileLocator.find((Bundle)bundle, (IPath)UnitTestprocedurePath, null);
            procedureLocation = FileLocator.toFileURL((URL)procedureLocation);
            procedure = new File(procedureLocation.getFile()).getAbsoluteFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return procedure;
    }

    private RunProgramInPa getPaProjectSessionRunContext(PaProject paProject) {
        RunProgramInPa runPaProgram = null;
        if (paProject != null) {
            if (paProject.isAvailable()) {
                try {
                    runPaProgram = new RunProgramInPa(paProject);
                }
                catch (ProALPHANotAvailableException e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"proALPHA not available", (String)"No proALPHA project available or still starting");
                }
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"proALPHA not available", (String)"No proALPHA project available or still starting");
            }
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No Project", (String)"No proALPHA project found");
        }
        return runPaProgram;
    }
}

