/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.zipper;

import com.progress.tools.reportbug.Constants;
import com.progress.tools.reportbug.model.Attachment;
import com.progress.tools.reportbug.model.BugData;
import com.progress.tools.reportbug.model.FileAttachment;
import com.progress.tools.reportbug.model.ProductAttachment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipCreator {
    private ZipOutputStream getZipOutputStream(File file) {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return zipOutputStream;
    }

    public File createZip(BugData bugData, File reportBugXMLFile, File saveFile) {
        if (saveFile == null) {
            saveFile = this.getTempFile();
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = this.getZipOutputStream(saveFile);
            this.addAttachmentsToZip(bugData.getAttachments(), zipOutputStream);
            this.addReportXMLToZip(reportBugXMLFile, zipOutputStream);
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return saveFile;
    }

    private void addReportXMLToZip(File reportBugXMLFile, ZipOutputStream zipOutputStream) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(reportBugXMLFile), "UTF-8"));
            String str = null;
            StringBuffer sb = new StringBuffer("");
            while ((str = br.readLine()) != null) {
                sb.append(str).append(Constants.LINE_SEPARATOR);
            }
            byte[] bytes = sb.toString().getBytes("UTF-8");
            this.createZipEntry("bugReport.xml", bytes, zipOutputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createZipEntry(String reportBugXmlFileName, byte[] bytes, ZipOutputStream zipOutputStream) {
        ZipEntry zipEntry = new ZipEntry(reportBugXmlFileName);
        zipEntry.setMethod(8);
        try {
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(bytes);
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getTempFile() {
        File file = null;
        try {
            file = File.createTempFile("BugReport", ".zip");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file.deleteOnExit();
        return file;
    }

    private void addAttachmentsToZip(List<Attachment> attachments, ZipOutputStream zipOutputStream) {
        for (Attachment attachment : attachments) {
            if (attachment instanceof ProductAttachment) {
                if (!((ProductAttachment)attachment).isSelected()) continue;
                this.createZipEntry(attachment, zipOutputStream);
                continue;
            }
            if (!(attachment instanceof FileAttachment)) continue;
            FileAttachment pathAttachment = (FileAttachment)attachment;
            if (pathAttachment.isDirectory()) {
                this.createZipEntries(pathAttachment, new File(pathAttachment.getFileLocation()), zipOutputStream);
                continue;
            }
            this.createZipEntry(pathAttachment, zipOutputStream);
        }
    }

    private void createZipEntries(FileAttachment pathAttachment, File parent, ZipOutputStream zipOutputStream) {
        String[] list;
        String[] stringArray = list = parent.list();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            File file = new File(parent, str);
            if (file.isDirectory()) {
                this.createZipEntries(pathAttachment, file, zipOutputStream);
            } else {
                File root = new File(pathAttachment.getFileLocation());
                String parentLoc = parent.toURI().toString();
                String rootLoc = root.toURI().toString();
                String relativePath = parentLoc.substring(rootLoc.length() - 1);
                FileAttachment attachment = new FileAttachment(String.valueOf(pathAttachment.getPathInZip()) + relativePath + str, file.getAbsolutePath());
                this.createZipEntry(attachment, zipOutputStream);
            }
            ++n2;
        }
    }

    private void createZipEntry(Attachment attachment, ZipOutputStream zipOutputStream) {
        ZipEntry zipEntry = new ZipEntry(attachment.getPathInZip());
        zipEntry.setMethod(8);
        try {
            try {
                zipOutputStream.putNextEntry(zipEntry);
                byte[] bytes = new byte[131072];
                attachment.openStream();
                int readChunk = 0;
                while ((readChunk = attachment.readChunk(bytes)) != -1) {
                    zipOutputStream.write(bytes, 0, readChunk);
                }
                attachment.closeStream();
            }
            catch (Exception exception) {
                try {
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                zipOutputStream.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public byte[] getBytes(File zipFile) {
        try {
            FileInputStream fis = new FileInputStream(zipFile);
            long length = zipFile.length();
            byte[] bytes = new byte[(int)length];
            fis.read(bytes);
            fis.close();
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

