/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.dialogs;

import com.progress.tools.reportbug.Constants;
import com.progress.tools.reportbug.ReportGenerator;
import com.progress.tools.reportbug.model.Report;
import com.progress.tools.reportbug.model.Response;
import com.progress.tools.reportbug.ui.Activator;
import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.dialogs.ResponseDialog;
import com.progress.tools.reportbug.ws.WSClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SendSavedReportDialog
extends TitleAreaDialog {
    private Text normalTxt;
    private org.eclipse.swt.widgets.List txt;
    private List<String> list;
    private InputStream stream;
    protected String reportFile;
    public static boolean flag = false;
    private Report report;
    private ZipFile zipFile;

    public SendSavedReportDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(65680);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ReportBugDialog_reportTechnicalIssueHeader);
        this.setTitle(Messages.ReportBugDialog_reportTechnicalIssue);
        this.setMessage(Messages.SendSavedReportDialog_dialogMessage);
        Image image = Activator.getDefault().getImageRegistry().get("icons/Report-Technical-Issue.gif");
        if (image != null) {
            this.setTitleImage(image);
        }
        return this.createUI(parent);
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    private Composite createUI(Composite parent) {
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout(3, false));
        topLevel.setLayoutData((Object)new GridData(4, 128, true, false));
        Label selectTxt = new Label(topLevel, 4);
        selectTxt.setText(Messages.SendSavedReportDialog_selectReport);
        this.normalTxt = new Text(topLevel, 2056);
        this.normalTxt.setText("");
        this.normalTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.normalTxt.setEditable(false);
        Button browse = new Button(topLevel, 8);
        browse.setText(Messages.SendSavedReportDialog_browseButton);
        browse.setFocus();
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dlg.setFilterExtensions(new String[]{"*.zip"});
                String selectedFilePath = dlg.open();
                if (selectedFilePath != null) {
                    SendSavedReportDialog.this.normalTxt.setText(selectedFilePath);
                }
            }
        });
        this.normalTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String selectedFilePath = SendSavedReportDialog.this.normalTxt.getText();
                if (SendSavedReportDialog.this.validateReport(selectedFilePath)) {
                    SendSavedReportDialog.this.setErrorMessage(null);
                    SendSavedReportDialog.this.getOKButton().setEnabled(true);
                    SendSavedReportDialog.this.reportFile = SendSavedReportDialog.this.normalTxt.getText();
                    SendSavedReportDialog.this.displayContents(selectedFilePath);
                    long length = new File(selectedFilePath).length();
                    if (length > Constants.MAX_ATTACH_SIZE) {
                        SendSavedReportDialog.this.setErrorMessage(Messages.ReportBugDialog_ATTACH_SIZE_ErrorMessage);
                        SendSavedReportDialog.this.getButton(0).setEnabled(false);
                    }
                } else {
                    SendSavedReportDialog.this.setErrorMessage(Messages.SendSavedReportDialog_validationMessage);
                    SendSavedReportDialog.this.txt.removeAll();
                    SendSavedReportDialog.this.getOKButton().setEnabled(false);
                }
            }
        });
        Composite bottomPanel = new Composite(parent, 4);
        bottomPanel.setLayout((Layout)new GridLayout(1, false));
        bottomPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(bottomPanel, 0);
        label.setText(Messages.SendSavedReportDialog_reportContents);
        this.txt = new org.eclipse.swt.widgets.List(bottomPanel, 2816);
        this.txt.setLayoutData((Object)new GridData(4, 4, true, true));
        return topLevel;
    }

    private boolean validateReport(String selectedFilePath) {
        boolean flag = false;
        this.zipFile = null;
        try {
            this.zipFile = new ZipFile(selectedFilePath);
            this.list = new ArrayList<String>();
            File f = new File(selectedFilePath);
            try {
                ZipEntry ent;
                FileInputStream fIn = new FileInputStream(f);
                ZipInputStream zIn = new ZipInputStream(fIn);
                while ((ent = zIn.getNextEntry()) != null) {
                    String entName = ent.getName();
                    if (entName != null) {
                        if (entName.endsWith("bugReport.xml")) {
                            this.stream = this.zipFile.getInputStream(ent);
                            flag = true;
                        }
                        this.list.add(ent.getName());
                        continue;
                    }
                    this.list.add(ent.getName());
                }
                try {
                    this.report = ReportGenerator.getInstance().parseXML(this.stream);
                    for (String o : this.list) {
                        this.txt.add(o);
                    }
                }
                catch (Exception exception) {
                    flag = false;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                flag = false;
            }
            catch (IOException iOException) {
                flag = false;
            }
        }
        catch (Exception exception) {
            flag = false;
        }
        return flag;
    }

    private void displayContents(String selectedFilePath) {
        this.txt.removeAll();
        File f = new File(selectedFilePath);
        try {
            ZipEntry ent;
            FileInputStream fIn = new FileInputStream(f);
            ZipInputStream zIn = new ZipInputStream(fIn);
            while ((ent = zIn.getNextEntry()) != null) {
                String entName = ent.getName();
                if (entName != null) {
                    if (entName.endsWith("bugReport.xml")) {
                        this.stream = this.zipFile.getInputStream(ent);
                    }
                    this.txt.add(ent.getName());
                    continue;
                }
                this.txt.add(ent.getName());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.SendSavedReportDialog_submitReport, true);
        this.getOKButton().setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    protected void okPressed() {
        flag = false;
        try {
            Job job = new Job(Messages.ReportBugDialog_PROGRESS_MONITOR_TITLE){

                public IStatus run(IProgressMonitor monitor) {
                    while (!flag) {
                        try {
                            try {
                                monitor.beginTask(Messages.ReportBugDialog_PROGRESS_MONITOR_DESCRIPTION, -1);
                                WSClient wsclient = new WSClient();
                                final Response response = wsclient.sendBugInfo(SendSavedReportDialog.this.report, new File(SendSavedReportDialog.this.reportFile));
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (response != null) {
                                            if (response.isSuccessful()) {
                                                flag = true;
                                                ResponseDialog dialog = new ResponseDialog(Display.getDefault().getActiveShell(), response);
                                                dialog.open();
                                            } else {
                                                boolean ret = MessageDialog.openQuestion(null, (String)Messages.ReportBugDialog_ERROR_TITLE, (String)Messages.SendSavedReportDialog_ERROR_MESSAGE);
                                                if (!ret) {
                                                    flag = true;
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        e.printStackTrace();
                                        boolean ret = MessageDialog.openQuestion(null, (String)Messages.ReportBugDialog_ERROR_TITLE, (String)Messages.SendSavedReportDialog_ERROR_MESSAGE);
                                        if (!ret) {
                                            flag = true;
                                        }
                                    }
                                });
                                monitor.done();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.done();
                            throw throwable;
                        }
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.okPressed();
    }
}

