/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.wizard.composite;

import com.progress.tools.reportbug.model.Attachment;
import com.progress.tools.reportbug.model.BugData;
import com.progress.tools.reportbug.model.FileAttachment;
import com.progress.tools.reportbug.model.WorkspacePathAttachment;
import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.ReportBugDialog;
import com.progress.tools.reportbug.ui.Utility;
import com.progress.tools.reportbug.ui.util.AttachmentUtil;
import com.progress.tools.reportbug.ui.wizard.composite.LogComposite;
import com.progress.tools.reportbug.zipper.SizeCalculator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AttachmentsComposite
extends Composite {
    protected long totalSize;
    protected long workspaceFilesSize;
    private Label totalSizeValue;
    private CTabFolder tabFolder;
    private CTabItem fileAttachmentsTab;
    private Table fileAttachmentTable;
    private Button menuButton;
    private Button removeButton;
    private List<Attachment> attachments;
    private String sizeMetric = Messages.BasicInformationWizardPage_KB;
    private CTabItem logsTab;
    private Button addButton;
    public Menu menuBar;
    public MenuItem fileChooserMenuItem;
    public MenuItem workspaceChooserMenuItem;
    private LogComposite logComposite;
    private BugData bugData;
    private ReportBugDialog reportBugDialog;

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public AttachmentsComposite(ReportBugDialog dialog, Composite parent, int style, BugData bugData) {
        super(parent, style);
        this.bugData = bugData;
        this.reportBugDialog = dialog;
        this.setLayout((Layout)new GridLayout(1, false));
        this.createUI();
        this.attachments = bugData.getAttachments() == null ? new ArrayList() : bugData.getAttachments();
    }

    private void createUI() {
        Group attachmentsGroup = Utility.getNewGroup(this, Messages.BasicInformationWizardPage_attachments, 1, true, false);
        this.createTabs(attachmentsGroup);
        Composite sizeComposite = new Composite((Composite)attachmentsGroup, 0);
        sizeComposite.setLayout((Layout)new GridLayout(2, false));
        sizeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label totalSizeLabel = new Label(sizeComposite, 0);
        totalSizeLabel.setText(Messages.BasicInformationWizardPage_totalSize);
        this.totalSizeValue = new Label(sizeComposite, 0);
        this.totalSizeValue.setText(Messages.BasicInformationWizardPage_defaultSize);
        this.updateSizeComponent();
    }

    private void createTabs(Group attachmentsGroup) {
        this.tabFolder = new CTabFolder((Composite)attachmentsGroup, 2048);
        GridData gd = new GridData(4, 4, true, true);
        this.tabFolder.setLayoutData((Object)gd);
        this.createLogsTab(this.tabFolder);
        this.createFileAttachmentTab(this.tabFolder);
        this.tabFolder.setSelection(0);
    }

    private void createLogsTab(CTabFolder tabFolder) {
        this.logsTab = new CTabItem(tabFolder, 0);
        this.logsTab.setText(Messages.BasicInformationWizardPage_resources);
        this.logComposite = new LogComposite(this.reportBugDialog, (Composite)tabFolder, this, 0);
        this.logComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        this.logComposite.setLayoutData(gd);
        this.logsTab.setControl((Control)this.logComposite);
    }

    private void createFileAttachmentTab(CTabFolder tabFolder) {
        this.fileAttachmentsTab = new CTabItem(tabFolder, 0);
        this.fileAttachmentsTab.setText(Messages.BasicInformationWizardPage_fileAttachments);
        Composite composite = new Composite((Composite)tabFolder, 4);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.fileAttachmentTable = new Table(composite, 2818);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 70;
        this.fileAttachmentTable.setLayoutData((Object)gd);
        this.fileAttachmentsTab.setControl((Control)composite);
        this.fileAttachmentTable.setToolTipText(Messages.AttachmentsComposite_fileTabTooltip);
        this.fileAttachmentTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachmentsComposite.this.updateRemoveButton();
            }
        });
        List attachments = this.bugData.getAttachments();
        this.displayResourceNames(attachments, this.fileAttachmentTable);
        this.updateSize(attachments, "add", null);
        this.updateSizeComponent();
        Composite buttons = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(4, 128, false, false));
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Messages.BasicInformationWizardPage_ADD);
        this.addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.addButton.addSelectionListener((SelectionListener)new MenuDisplayActionListener());
        this.menuButton = new Button(buttons, 1028);
        this.menuButton.addSelectionListener((SelectionListener)new MenuDisplayActionListener());
        GridData data = new GridData(16384, 4, false, false);
        this.menuButton.setLayoutData((Object)data);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Messages.BasicInformationWizardPage_Remove);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.removeButton.setLayoutData((Object)layoutData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selections = AttachmentsComposite.this.fileAttachmentTable.getSelectionIndices();
                AttachmentsComposite.this.fileAttachmentTable.remove(selections);
                AttachmentsComposite.this.removeItemsFromModel(selections);
                AttachmentsComposite.this.updateRemoveButton();
            }
        });
        this.removeButton.setEnabled(false);
    }

    private void updateRemoveButton() {
        if (this.fileAttachmentTable.getSelectionCount() < 1) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    public void updateSize(long modifiedElementsSize, String operation) {
        this.totalSize = operation.equals("add") ? (this.totalSize += modifiedElementsSize) : (this.totalSize -= modifiedElementsSize);
    }

    public void updateSizeComponent() {
        if (this.totalSizeValue != null) {
            double displaySize = this.totalSize / 1024L;
            if (displaySize == 0.0 && this.totalSize > 0L) {
                displaySize = 1.0;
            }
            if (displaySize > 1024.0) {
                displaySize /= 1024.0;
                this.sizeMetric = Messages.BasicInformationWizardPage_MB;
                displaySize = (double)Math.round(displaySize * 100.0) / 100.0;
                this.totalSizeValue.setText(String.valueOf(displaySize) + this.sizeMetric);
            } else {
                this.sizeMetric = Messages.BasicInformationWizardPage_KB;
                this.totalSizeValue.setText(String.valueOf((long)displaySize) + this.sizeMetric);
            }
            this.totalSizeValue.getParent().layout();
        }
        this.reportBugDialog.validate();
    }

    private long updateSize(List<? extends Attachment> fileAttachments, String operation, IProgressMonitor monitor) {
        long size = 0L;
        for (Attachment attachment : fileAttachments) {
            long length = attachment.getLength();
            this.updateSize(length, operation);
            size += length;
            if (monitor == null) continue;
            monitor.worked(1);
        }
        return size;
    }

    private void removeItemsFromModel(int[] selections) {
        final ArrayList<Attachment> removalList = new ArrayList<Attachment>();
        int i = 0;
        while (i < selections.length) {
            removalList.add(this.attachments.get(selections[i]));
            ++i;
        }
        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

            protected void setShellStyle(int newShellStyle) {
                super.setShellStyle(3.getDefaultOrientation() | 0x800 | 0x20 | 0x10000 | 0x10 | 0x400);
            }
        };
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    dialog.setCancelable(false);
                    int total = removalList.size();
                    monitor.beginTask(Messages.AttachmentsComposite_Removing, total);
                    for (Attachment attachment : removalList) {
                        if (attachment instanceof FileAttachment) {
                            FileAttachment pathAttachment = (FileAttachment)attachment;
                            long size = SizeCalculator.calculateSize((File)new File(pathAttachment.getFileLocation()));
                            AttachmentsComposite.this.updateSize(size, "remove");
                        }
                        monitor.worked(1);
                    }
                    AttachmentsComposite.this.attachments.removeAll(removalList);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AttachmentsComposite.this.updateSizeComponent();
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.reportBugDialog.validate();
    }

    public LogComposite getLogComposite() {
        return this.logComposite;
    }

    private void displayResourceNames(List<? extends Attachment> selectedResources, Table resourcesTable) {
        for (Attachment attachment : selectedResources) {
            TableItem item = new TableItem(resourcesTable, 2048);
            if (attachment instanceof WorkspacePathAttachment) {
                item.setText(attachment.getPathInZip());
                continue;
            }
            if (!(attachment instanceof FileAttachment)) continue;
            item.setText(((FileAttachment)attachment).getFileLocation());
        }
    }

    private void addSelectedToModel(List<FileAttachment> resources) {
        ArrayList<FileAttachment> duplicateAttachments = new ArrayList<FileAttachment>();
        for (FileAttachment attachment : resources) {
            boolean existing = false;
            for (Attachment existingAttachment : this.attachments) {
                if (!existingAttachment.equals(attachment)) continue;
                existing = true;
                duplicateAttachments.add(attachment);
            }
            if (existing) continue;
            this.attachments.add((Attachment)attachment);
        }
        resources.removeAll(duplicateAttachments);
    }

    private void onResourceSelectionChange(final List<FileAttachment> attachments) {
        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

            protected void setShellStyle(int newShellStyle) {
                super.setShellStyle(5.getDefaultOrientation() | 0x800 | 0x20 | 0x10000 | 0x10 | 0x400);
            }
        };
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    dialog.setCancelable(false);
                    int total = attachments.size();
                    monitor.beginTask(Messages.AttachmentsComposite_Adding, total);
                    AttachmentsComposite.this.addSelectedToModel(attachments);
                    AttachmentsComposite.this.updateSize(attachments, "add", monitor);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AttachmentsComposite.this.displayResourceNames(attachments, AttachmentsComposite.this.fileAttachmentTable);
                            AttachmentsComposite.this.updateSizeComponent();
                        }
                    });
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.reportBugDialog.validate();
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    private class MenuDisplayActionListener
    extends SelectionAdapter {
        private MenuDisplayActionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Rectangle bounds = AttachmentsComposite.this.addButton.getBounds();
            Point point = AttachmentsComposite.this.addButton.getParent().toDisplay(new Point(bounds.x, bounds.y + ((AttachmentsComposite)AttachmentsComposite.this).addButton.getSize().y));
            AttachmentsComposite.this.addButton.setMenu(AttachmentsComposite.this.menuBar);
            AttachmentsComposite.this.menuBar = new Menu((Decorations)AttachmentsComposite.this.addButton.getShell(), 0);
            AttachmentsComposite.this.workspaceChooserMenuItem = new MenuItem(AttachmentsComposite.this.menuBar, 0);
            AttachmentsComposite.this.workspaceChooserMenuItem.setText(Messages.AttachmentsComposite_MENU_ITEM_WORKSPACE);
            AttachmentsComposite.this.fileChooserMenuItem = new MenuItem(AttachmentsComposite.this.menuBar, 64);
            AttachmentsComposite.this.fileChooserMenuItem.setText(Messages.AttachmentsComposite_MENU_ITEM_LOCAL_FILE_SYSTEM);
            AttachmentsComposite.this.menuBar.setVisible(true);
            AttachmentsComposite.this.menuBar.setLocation(point);
            AttachmentsComposite.this.workspaceChooserMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementTreeSelectionDialog workspaceDialog = new ElementTreeSelectionDialog(AttachmentsComposite.this.tabFolder.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                    workspaceDialog.setTitle(Messages.BasicInformationWizardPage_chooseResources);
                    workspaceDialog.setMessage(Messages.BasicInformationWizardPage_selectElements);
                    workspaceDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                    workspaceDialog.open();
                    workspaceDialog.setAllowMultiple(true);
                    Object[] result = workspaceDialog.getResult();
                    if (result != null) {
                        List<FileAttachment> selectedWorkspaceResources = AttachmentUtil.convertToWorkspaceAttachments(result);
                        AttachmentsComposite.this.onResourceSelectionChange(selectedWorkspaceResources);
                        AttachmentsComposite.this.addSelectedToModel(selectedWorkspaceResources);
                    }
                }
            });
            AttachmentsComposite.this.fileChooserMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fd = new FileDialog(((MenuItem)e.widget).getParent().getShell(), 2);
                    fd.setText(Messages.BasicInformationWizardPage_SelectFile);
                    fd.open();
                    String[] fileNames = fd.getFileNames();
                    String filterPath = fd.getFilterPath();
                    ArrayList<FileAttachment> selectedAttachments = new ArrayList<FileAttachment>();
                    if (fileNames != null && fileNames.length > 0) {
                        String[] stringArray = fileNames;
                        int n = fileNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileName = stringArray[n2];
                            File f = new File(filterPath, fileName);
                            FileAttachment attachment = new FileAttachment("attachments/" + f.getName(), f.getAbsolutePath());
                            selectedAttachments.add(attachment);
                            ++n2;
                        }
                    }
                    AttachmentsComposite.this.onResourceSelectionChange(selectedAttachments);
                }
            });
        }
    }
}

