/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.jira.core.JiraFieldType;
import com.atlassian.connector.eclipse.internal.jira.core.Messages;

public enum JiraAttribute {
    ACTUAL("attribute.jira.actual", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Time_Spent, false, true, "timespent"),
    AFFECTSVERSIONS("attribute.jira.affectsversions", JiraFieldType.MULTISELECT, Messages.JiraAttribute_Affects_Versions, false, false, "versions"),
    COMMENT_NEW("task.common.comment.new", JiraFieldType.TEXTAREA, Messages.JiraAttribute_New_Comment, true, false, "comment"),
    COMPONENTS("attribute.jira.components", JiraFieldType.MULTISELECT, Messages.JiraAttribute_Components, false, false, "components"),
    CREATION_DATE("task.common.date.created", JiraFieldType.DATE, Messages.JiraAttribute_Created),
    DESCRIPTION("task.common.description", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Description, true, false, "description"),
    DUE_DATE("attribute.jira.due", JiraFieldType.DATE, Messages.JiraAttribute_DUEDATE, false, false, "duedate"),
    ENVIRONMENT("attribute.jira.environment", JiraFieldType.TEXTAREA, Messages.JiraAttribute_Environment, false, false, "environment"),
    ESTIMATE("attribute.jira.estimate", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Estimate, false, false, "timetracking"),
    FIXVERSIONS("attribute.jira.fixversions", JiraFieldType.MULTISELECT, Messages.JiraAttribute_Fix_Versions, false, false, "fixVersions"),
    INITIAL_ESTIMATE("attribute.jira.initialestimate", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Original_Estimate, false, true),
    ISSUE_KEY("task.common.key", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Key),
    LINKED_IDS("attribute.jira.link_ids", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Linked_ids, true, true),
    MODIFICATION_DATE("task.common.date.modified", JiraFieldType.DATE, Messages.JiraAttribute_Modified),
    PARENT_ID("attribute.jira.issue_parent_id", JiraFieldType.ISSUELINK, Messages.JiraAttribute_Parent_ID, true, true),
    PARENT_KEY("attribute.jira.issue_parent_key", JiraFieldType.ISSUELINK, Messages.JiraAttribute_Parent, false, true),
    PRIORITY("task.common.priority", JiraFieldType.SELECT, Messages.JiraAttribute_Priority, false, false, "priority"),
    PROJECT("task.common.product", JiraFieldType.PROJECT, Messages.JiraAttribute_Project, false, true),
    RESOLUTION("task.common.resolution", JiraFieldType.SELECT, Messages.JiraAttribute_Resolution, true, false, "resolution"),
    SECURITY_LEVEL("attribute.jira.security", JiraFieldType.SELECT, Messages.JiraAttribute_Security_Level, false, false),
    STATUS("task.common.status", JiraFieldType.SELECT, Messages.JiraAttribute_Status),
    SUBTASK_IDS("attribute.jira.subtask_ids", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Subtask_ids, true, true),
    SUBTASK_KEYS("attribute.jira.subtask_keys", JiraFieldType.ISSUELINKS, Messages.JiraAttribute_Subtasks, false, true),
    SUMMARY("task.common.summary", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Summary, true, false, "summary"),
    TYPE("attribute.jira.type", JiraFieldType.SELECT, Messages.JiraAttribute_Type, false, false, "issuetype"),
    UNKNOWN(null, JiraFieldType.UNKNOWN, Messages.JiraAttribute_unknown, true, true),
    USER_ASSIGNED("task.common.user.assigned", JiraFieldType.USERPICKER, Messages.JiraAttribute_Assigned_to, true, false, "assignee"),
    USER_REPORTER("task.common.user.reporter", JiraFieldType.USERPICKER, Messages.JiraAttribute_Reported_by),
    TASK_URL("task.common.url", JiraFieldType.URL, Messages.JiraAttribute_URL),
    PROJECT_ROLES("attribute.jira.project-roles", JiraFieldType.SELECT, Messages.JiraAttribute_Viewable_by, true, false),
    VOTES("attribute.jira.votes", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Votes, true, true),
    LABELS("attribute.jira.labels", JiraFieldType.LABELS, Messages.JiraAttribute_Labels, false, false),
    RANK("task.common.rank", JiraFieldType.RANK, Messages.JiraAttribute_unknown, true, true),
    EPIC_KEY("attribute.jira.issue_epic_key", JiraFieldType.ISSUELINK, Messages.JiraAttribute_Epic, false, true),
    SPRINT_NAME("attribute.jira.issue_sprint_key", JiraFieldType.TEXTFIELD, Messages.JiraAttribute_Sprint, false, true);

    private final String id;
    private final boolean isHidden;
    private final boolean isReadOnly;
    private final String name;
    private final String paramName;
    private final JiraFieldType type;

    public static JiraAttribute valueById(String id) {
        JiraAttribute[] jiraAttributeArray = JiraAttribute.values();
        int n = jiraAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JiraAttribute attribute = jiraAttributeArray[n2];
            if (id.equals(attribute.id())) {
                return attribute;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    private JiraAttribute(String id, JiraFieldType type, String name) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = true;
        this.isReadOnly = true;
        this.paramName = null;
    }

    private JiraAttribute(String id, JiraFieldType type, String name, boolean isHidden, boolean isReadOnly) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = isHidden;
        this.isReadOnly = isReadOnly;
        this.paramName = null;
    }

    private JiraAttribute(String id, JiraFieldType type, String name, boolean isHidden, boolean isReadOnly, String paramName) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = isHidden;
        this.isReadOnly = isReadOnly;
        this.paramName = paramName;
    }

    public String id() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParamName() {
        return this.paramName;
    }

    public JiraFieldType getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getKind() {
        return this.isHidden ? null : "task.common.kind.default";
    }
}

