/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.actions;

import com.atlassian.connector.eclipse.internal.jira.ui.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectWorkflowActionDialog
extends MessageDialog {
    private static final String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
    private final TaskRepository repository;
    private final TaskData taskData;
    private final boolean startWork;
    private final List<TaskOperation> operations;
    private String selectedAction = "-1";
    private Combo actionsComboBox;

    public SelectWorkflowActionDialog(Shell parentShell, TaskData taskData, ITask iTask, boolean startWork) {
        super(parentShell, NLS.bind((String)(startWork ? Messages.SelectWorkflowAction_Start_Title : Messages.SelectWorkflowAction_Stop_Title), (Object)iTask.getTaskKey()), null, null, 0, buttons, 0);
        this.taskData = taskData;
        this.startWork = startWork;
        this.repository = TasksUi.getRepositoryManager().getRepository(iTask.getConnectorKind(), iTask.getRepositoryUrl());
        TaskAttribute selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        this.operations = taskData.getAttributeMapper().getTaskOperations(selectedOperationAttribute);
    }

    protected Point getInitialSize() {
        return new Point(350, 150);
    }

    protected Control createMessageArea(Composite composite) {
        super.createMessageArea(composite);
        Composite c1 = new Composite(composite, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.horizontalSpacing = 10;
        gl.verticalSpacing = 10;
        gl.marginWidth = 0;
        c1.setLayout((Layout)gl);
        this.actionsComboBox = new Combo(c1, 12);
        ArrayList<String> items = new ArrayList<String>();
        for (TaskOperation operation : this.operations) {
            try {
                Integer.parseInt(operation.getOperationId());
                items.add(operation.getLabel());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.actionsComboBox.setItems(items.toArray(new String[items.size()]));
        if (items.size() > 0) {
            this.actionsComboBox.select(0);
        }
        new Label(c1, 0).setText(Messages.SelectWorkflowAction_Label);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.updateSelectedAction();
        }
        super.buttonPressed(buttonId);
    }

    private void updateSelectedAction() {
        int sel = this.actionsComboBox.getSelectionIndex();
        String val = this.actionsComboBox.getItem(sel);
        for (TaskOperation operation : this.operations) {
            if (!val.equals(operation.getLabel())) continue;
            this.selectedAction = operation.getOperationId();
            break;
        }
    }

    public String getSelectedAction() {
        return this.selectedAction;
    }
}

