/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.editor;

import com.atlassian.connector.eclipse.internal.jira.core.JiraTaskDataHandler;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.NumberAttributeEditor;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.TimeSpanAttributeEditor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.mylyn.internal.tasks.ui.editors.CheckboxMultiSelectAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.PersonAttributeEditor;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.services.IServiceLocator;

class JiraAttributeEditorFactory
extends AttributeEditorFactory {
    private final TaskDataModel model;

    public JiraAttributeEditorFactory(TaskDataModel model, TaskRepository taskRepository, IServiceLocator serviceLocator) {
        super(model, taskRepository, serviceLocator);
        this.model = model;
    }

    public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
        if (JiraTaskDataHandler.isTimeSpanAttribute((TaskAttribute)taskAttribute)) {
            return new TimeSpanAttributeEditor(this.model, taskAttribute);
        }
        if ("multiSelect".equals(type)) {
            CheckboxMultiSelectAttributeEditor attributeEditor = new CheckboxMultiSelectAttributeEditor(this.model, taskAttribute);
            attributeEditor.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
            return attributeEditor;
        }
        if ("type_number".equals(type)) {
            return new NumberAttributeEditor(this.model, taskAttribute);
        }
        if ("person".equals(type)) {
            return new PersonAttributeEditor(this.model, taskAttribute){

                public String getValue() {
                    IRepositoryPerson repositoryPerson;
                    if (this.isReadOnly() && (repositoryPerson = this.getAttributeMapper().getRepositoryPerson(this.getTaskAttribute())) != null) {
                        String name = repositoryPerson.getName();
                        if (name != null) {
                            return name;
                        }
                        return repositoryPerson.getPersonId();
                    }
                    return super.getValue();
                }

                public void createControl(Composite parent, FormToolkit toolkit) {
                    super.createControl(parent, toolkit);
                    IRepositoryPerson repositoryPerson = this.getAttributeMapper().getRepositoryPerson(this.getTaskAttribute());
                    if (repositoryPerson != null) {
                        if (this.isReadOnly()) {
                            if (!StringUtils.isBlank((CharSequence)repositoryPerson.getPersonId())) {
                                this.getControl().setToolTipText(repositoryPerson.getPersonId());
                            }
                        } else if (!StringUtils.isBlank((CharSequence)repositoryPerson.getName()) && this.getText() != null) {
                            this.getText().setToolTipText(repositoryPerson.getName());
                        }
                    }
                }
            };
        }
        return super.createEditor(type, taskAttribute);
    }
}

