/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.wizards;

import com.atlassian.connector.eclipse.internal.jira.core.JiraAttribute;
import com.atlassian.connector.eclipse.internal.jira.core.JiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.JiraCorePlugin;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDefinition;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ProjectFilter;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.wizards.Messages;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.progress.UIJob;

public class JiraProjectPage
extends WizardPage {
    private FilteredTree projectTree;
    private final TaskRepository repository;
    private Button offlineButton;

    public JiraProjectPage(TaskRepository repository) {
        super("jiraProject");
        Assert.isNotNull((Object)repository);
        this.setTitle(Messages.JiraProjectPage_New_JIRA_Task);
        this.setDescription(Messages.JiraProjectPage_Pick_a_project_to_open_the_new_bug_editor);
        this.repository = repository;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        PatternFilter patternFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                Project project;
                if (element instanceof Project && this.wordMatches((project = (Project)element).getKey())) {
                    return true;
                }
                return super.isLeafMatch(viewer, element);
            }
        };
        this.projectTree = new FilteredTree(composite, 2052, patternFilter, true);
        this.projectTree.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(-1, 200).create());
        TreeViewer projectTreeViewer = this.projectTree.getViewer();
        projectTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Project) {
                    Project project = (Project)element;
                    return String.valueOf(project.getName()) + "  (" + project.getKey() + ")";
                }
                return "";
            }
        });
        projectTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Project[]) {
                    return (Project[])parentElement;
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.updateProjectsFromRepository(false);
        final Project[] projects = this.discoverProject();
        if (projects != null && projects.length > 0) {
            new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TreeViewer viewer = JiraProjectPage.this.projectTree.getViewer();
                    if (viewer != null && viewer.getTree() != null && !viewer.getTree().isDisposed()) {
                        viewer.setSelection((ISelection)new StructuredSelection((Object[])projects));
                        viewer.reveal((Object)projects);
                        viewer.getTree().showSelection();
                        viewer.getTree().setFocus();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule(300L);
        }
        projectTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (JiraProjectPage.this.getSelectedProject() == null) {
                    JiraProjectPage.this.setErrorMessage(Messages.JiraProjectPage_You_must_select_a_project);
                } else if (!JiraProjectPage.this.getSelectedProject().hasDetails()) {
                    JiraProjectPage.this.setMessage(Messages.JiraProjectPage_This_project_has_details_missing);
                } else {
                    JiraProjectPage.this.setErrorMessage(null);
                    JiraProjectPage.this.setMessage(null);
                }
                JiraProjectPage.this.getWizard().getContainer().updateButtons();
            }
        });
        projectTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (JiraProjectPage.this.getWizard().canFinish() && JiraProjectPage.this.getWizard().performFinish()) {
                    ((WizardDialog)JiraProjectPage.this.getContainer()).close();
                }
            }
        });
        projectTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Project) {
                    return JiraProjectPage.this.offlineButton != null && !JiraProjectPage.this.offlineButton.getSelection() || ((Project)element).hasDetails();
                }
                return false;
            }
        });
        this.projectTree.getFilterControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = JiraProjectPage.this.projectTree.getFilterControl().getText();
                if (!StringUtils.isEmpty((CharSequence)text) && !text.equals(WorkbenchMessages.FilteredTree_FilterMessage) && JiraProjectPage.this.offlineButton != null && JiraProjectPage.this.offlineButton.getSelection()) {
                    JiraProjectPage.this.offlineButton.setSelection(false);
                }
            }
        });
        this.offlineButton = new Button(composite, 32);
        this.offlineButton.setText("Show only projects available in offline mode");
        this.offlineButton.setSelection(true);
        this.offlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraProjectPage.this.projectTree.getViewer().refresh();
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)this.offlineButton);
        Button updateButton = new Button(composite, 16392);
        updateButton.setText(Messages.JiraProjectPage_Update_Project_Listing);
        updateButton.setLayoutData((Object)new GridData());
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JiraProjectPage.this.updateProjectsFromRepository(true);
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return this.getSelectedProject() != null;
    }

    private void updateProjectsFromRepository(boolean force) {
        JiraClient client = JiraClientFactory.getDefault().getJiraClient(this.repository);
        if (!client.getCache().hasDetails() || force) {
            ICoreRunnable runner = new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        JiraClient client = JiraClientFactory.getDefault().getJiraClient(JiraProjectPage.this.repository);
                        client.getCache().refreshDetails(monitor);
                    }
                    catch (JiraException e) {
                        throw new CoreException(JiraCorePlugin.toStatus((TaskRepository)JiraProjectPage.this.repository, (Throwable)e));
                    }
                }
            };
            try {
                if (this.getContainer().getShell().isVisible()) {
                    CommonUiUtil.run((IRunnableContext)this.getContainer(), (ICoreRunnable)runner);
                } else {
                    WorkbenchUtil.busyCursorWhile((ICoreRunnable)runner);
                }
            }
            catch (OperationCanceledException e) {
                return;
            }
            catch (CoreException e) {
                CommonUiUtil.setMessage((DialogPage)this, (IStatus)e.getStatus());
            }
        }
        Project[] projects = client.getCache().getProjects();
        this.projectTree.getViewer().setInput((Object)projects);
        this.getWizard().getContainer().updateButtons();
        if (projects.length == 1 && this.projectTree.getViewer().getSelection().isEmpty()) {
            this.projectTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)projects[0]));
        } else {
            this.projectTree.setFocus();
        }
    }

    public Project getSelectedProject() {
        IStructuredSelection selection = (IStructuredSelection)this.projectTree.getViewer().getSelection();
        return (Project)selection.getFirstElement();
    }

    private Project[] discoverProject() {
        ProjectFilter projectFilter;
        JiraClient client;
        FilterDefinition filter;
        IRepositoryQuery query;
        Object element = this.getSelectedElement();
        if (element == null) {
            return new Project[0];
        }
        if (element instanceof ITask) {
            ITask task = (ITask)element;
            if (task.getRepositoryUrl().equals(this.repository.getRepositoryUrl())) {
                try {
                    TaskData taskData = TasksUi.getTaskDataManager().getTaskData(task);
                    Project project = this.getProject(taskData);
                    if (project != null) {
                        return new Project[]{project};
                    }
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.jira.ui", "Failed to determine selected project", (Throwable)e));
                }
            }
        } else if (element instanceof IRepositoryQuery && (query = (IRepositoryQuery)element).getRepositoryUrl().equals(this.repository.getRepositoryUrl()) && (filter = JiraUtil.getFilterDefinition((TaskRepository)this.repository, (JiraClient)(client = JiraClientFactory.getDefault().getJiraClient(this.repository)), (IRepositoryQuery)query, (boolean)false)) != null && (projectFilter = filter.getProjectFilter()) != null) {
            return projectFilter.getProjects();
        }
        return new Project[0];
    }

    private Object getSelectedElement() {
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            return selection.getFirstElement();
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof TaskEditorInput) {
            return ((TaskEditorInput)editorInput).getTask();
        }
        return null;
    }

    private Project getProject(TaskData taskData) {
        TaskAttribute attribute;
        if (taskData != null && (attribute = taskData.getRoot().getMappedAttribute(JiraAttribute.PROJECT.id())) != null) {
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(this.repository);
            return client.getCache().getProjectById(attribute.getValue());
        }
        return null;
    }

    private IStructuredSelection getSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }
}

