/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui;

import com.atlassian.connector.eclipse.internal.commons.ui.MigrateToSecureStorageJob;
import com.atlassian.connector.eclipse.internal.jira.core.JiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.ui.JiraTaskRepositoryLocationUiFactory;
import com.atlassian.connector.eclipse.internal.jira.ui.JiraUiUtil;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JiraUiPlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "com.atlassian.connector.eclipse.jira.ui";
    public static final String PRODUCT_NAME = "Atlassian JIRA Connector";
    private static JiraUiPlugin instance;
    private final ITaskActivityListener activityTimeListener = new TaskActivityAdapter(){
        private boolean initialized = false;

        public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
            if (this.initialized && newElapsedTime == 0L) {
                JiraUiUtil.clearLoggedActivityTime(task);
            }
        }

        public void activityReset() {
            this.initialized = true;
        }
    };

    public static JiraUiPlugin getDefault() {
        return instance;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.jira", (String)path);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put("icons/obj16/comment.gif", JiraUiPlugin.getImageDescriptor("icons/obj16/comment.gif"));
        reg.put("icons/obj16/jira.png", JiraUiPlugin.getImageDescriptor("icons/obj16/jira.png"));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        JiraClientFactory.getDefault().setTaskRepositoryLocationFactory((TaskRepositoryLocationFactory)new JiraTaskRepositoryLocationUiFactory(), false);
        TasksUi.getRepositoryManager().addListener((IRepositoryListener)JiraClientFactory.getDefault());
        if (!this.getPreferenceStore().getBoolean("secure_storage.migration.done")) {
            MigrateToSecureStorageJob migrateJob = new MigrateToSecureStorageJob("jira");
            migrateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    super.done(event);
                    JiraUiPlugin.this.getPreferenceStore().setValue("secure_storage.migration.done", Boolean.TRUE.booleanValue());
                }
            });
            migrateJob.schedule();
        }
        TasksUiPlugin.getTaskActivityManager().addActivityListener(this.activityTimeListener);
    }

    public void stop(BundleContext context) throws Exception {
        TasksUiPlugin.getTaskActivityManager().removeActivityListener(this.activityTimeListener);
        TasksUi.getRepositoryManager().removeListener((IRepositoryListener)JiraClientFactory.getDefault());
        JiraClientFactory.getDefault().logOutFromAll();
        instance = null;
        super.stop(context);
    }
}

