/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.actions;

import com.atlassian.connector.eclipse.internal.jira.core.JiraAttribute;
import com.atlassian.connector.eclipse.internal.jira.core.JiraTaskDataHandler;
import com.atlassian.connector.eclipse.internal.jira.ui.IJiraTask;
import com.atlassian.connector.eclipse.internal.jira.ui.JiraImages;
import com.atlassian.connector.eclipse.internal.jira.ui.actions.AbstractJiraAction;
import java.util.List;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public abstract class AbstractStartWorkAction
extends AbstractJiraAction {
    public AbstractStartWorkAction() {
        super("Start/Stop Work Action");
        this.setImageDescriptor(JiraImages.START_PROGRESS);
    }

    @Override
    protected void doAction(List<IJiraTask> tasks) {
    }

    protected static boolean isAssignedToMe(TaskData taskData, ITask task) {
        if (taskData == null || task == null) {
            return false;
        }
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        if (repository == null) {
            return false;
        }
        TaskAttribute rootAttribute = taskData.getRoot();
        if (rootAttribute == null) {
            return false;
        }
        return repository.getUserName() != null && repository.getUserName().equals(task.getOwner());
    }

    protected static boolean isTaskInProgress(TaskData taskData, ITask task) {
        return AbstractStartWorkAction.isAssignedToMe(taskData, task) && AbstractStartWorkAction.isInProgressState(taskData);
    }

    protected static boolean isTaskInStop(TaskData taskData, ITask task) {
        if (AbstractStartWorkAction.isAssignedToMe(taskData, task) && AbstractStartWorkAction.haveStartProgressOperation(taskData)) {
            return true;
        }
        return AbstractStartWorkAction.isInOpenState(taskData);
    }

    protected static boolean haveStopProgressOperation(TaskData taskData) {
        return AbstractStartWorkAction.haveOperation(taskData, "301");
    }

    protected static boolean haveStartProgressOperation(TaskData taskData) {
        return AbstractStartWorkAction.haveOperation(taskData, "4");
    }

    private static boolean haveOperation(TaskData taskData, String operationId) {
        if (taskData == null) {
            return false;
        }
        TaskAttribute selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        List operations = taskData.getAttributeMapper().getTaskOperations(selectedOperationAttribute);
        for (TaskOperation operation : operations) {
            if (!operationId.equals(operation.getOperationId())) continue;
            return true;
        }
        return false;
    }

    private static boolean isInOpenState(TaskData taskData) {
        if (taskData == null) {
            return false;
        }
        String statusId = taskData.getRoot().getAttribute(JiraAttribute.STATUS.id()).getValue();
        return statusId != null && (statusId.equals(JiraTaskDataHandler.OPEN_STATUS) || statusId.equals(JiraTaskDataHandler.REOPEN_STATUS));
    }

    private static boolean isInProgressState(TaskData taskData) {
        if (taskData == null) {
            return false;
        }
        String statusId = taskData.getRoot().getAttribute(JiraAttribute.STATUS.id()).getValue();
        return statusId != null && statusId.equals(JiraTaskDataHandler.IN_PROGRESS_STATUS);
    }
}

