/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.editor;

import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.Messages;
import java.text.ParseException;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class JiraEditorUtil {
    private static final String DECORATOR_KEY = "DECORATOR";

    public static void setTimeSpentDecorator(Text toDecorate, boolean isZeroValid, TaskRepository repository, boolean isEmptyValid) {
        boolean invalid = false;
        if (isEmptyValid && (toDecorate.getText() == null || toDecorate.getText().length() == 0)) {
            invalid = false;
        } else {
            try {
                long amount = JiraUtil.getTimeFormat((TaskRepository)repository).parse(toDecorate.getText());
                invalid = isZeroValid ? amount < 0L : amount < 1L;
            }
            catch (ParseException e) {
                invalid = true;
            }
        }
        JiraEditorUtil.showTimeSpentDecorator(toDecorate, repository, invalid);
    }

    public static void showTimeSpentDecorator(Text toDecorate, TaskRepository repository, boolean show) {
        String errorDescription = NLS.bind((String)Messages.JiraEditorUtil_Time_Spent_Error_Decorator_Hover, (Object)JiraUtil.getWorkDaysPerWeek((TaskRepository)repository), (Object)JiraUtil.getWorkHoursPerDay((TaskRepository)repository));
        JiraEditorUtil.showTimeSpentDecorator(toDecorate, repository, errorDescription, show);
    }

    public static void showTimeSpentDecorator(Text toDecorate, TaskRepository repository, String errorDescription, boolean show) {
        if (toDecorate == null || toDecorate.isDisposed()) {
            return;
        }
        String decorationId = "DEC_ERROR";
        ControlDecoration amountTextControlDecoration = null;
        if (toDecorate.getData(DECORATOR_KEY) instanceof ControlDecoration) {
            amountTextControlDecoration = (ControlDecoration)toDecorate.getData(DECORATOR_KEY);
        }
        if (amountTextControlDecoration == null) {
            amountTextControlDecoration = new ControlDecoration((Control)toDecorate, 16512);
            toDecorate.setData(DECORATOR_KEY, (Object)amountTextControlDecoration);
            amountTextControlDecoration.setShowOnlyOnFocus(false);
        }
        amountTextControlDecoration.setDescriptionText(errorDescription);
        FieldDecoration errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration(decorationId);
        amountTextControlDecoration.setImage(errorImage.getImage());
        if (show) {
            amountTextControlDecoration.show();
        } else {
            amountTextControlDecoration.hide();
        }
    }
}

