/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.editor;

import com.atlassian.connector.eclipse.internal.jira.core.service.JiraTimeFormat;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.JiraEditorUtil;
import java.text.ParseException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TimeSpanAttributeEditor
extends AbstractAttributeEditor {
    private Text text;
    private final JiraTimeFormat format;

    public TimeSpanAttributeEditor(TaskDataModel model, TaskAttribute taskAttribute) {
        super(model, taskAttribute);
        this.format = JiraUtil.getTimeFormat((TaskRepository)model.getTaskRepository());
    }

    protected Text getText() {
        return this.text;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.text = new Text(parent, 0x800008);
            this.text.setFont(JFaceResources.getDefaultFont());
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setText(this.getValue());
        } else {
            this.text = toolkit.createText(parent, this.getValue(), 0x800000);
            this.text.setFont(JFaceResources.getDefaultFont());
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TimeSpanAttributeEditor.this.setValue(TimeSpanAttributeEditor.this.text.getText());
                }
            });
        }
        toolkit.adapt((Control)this.text, false, false);
        this.setControl((Control)this.text);
    }

    public String getValue() {
        return this.format.format((Object)this.getAttributeMapper().getLongValue(this.getTaskAttribute()));
    }

    public void setValue(String text) {
        try {
            if (text != null && text.length() > 0) {
                this.getAttributeMapper().setLongValue(this.getTaskAttribute(), Long.valueOf(this.format.parse(text)));
            } else {
                this.getAttributeMapper().setLongValue(this.getTaskAttribute(), null);
            }
            this.attributeChanged();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        JiraEditorUtil.setTimeSpentDecorator(this.text, true, this.getModel().getTaskRepository(), true);
    }
}

