/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.editor;

import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraTimeFormat;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;

public class WorkLogTableLabelProvider
extends ColumnLabelProvider {
    private final JiraTimeFormat format;

    public WorkLogTableLabelProvider(JiraTimeFormat format) {
        this.format = format;
    }

    public String getColumnText(Object element, int columnIndex) {
        JiraWorkLog attachment = (JiraWorkLog)element;
        switch (columnIndex) {
            case 0: {
                return attachment.getAuthor();
            }
            case 1: {
                if (attachment.getStartDate() != null) {
                    return attachment.getStartDate().toString();
                }
                return "";
            }
            case 2: {
                return this.format.format((Object)attachment.getTimeSpent());
            }
            case 3: {
                return attachment.getComment();
            }
        }
        return "unrecognized column";
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        cell.setText(this.getColumnText(cell.getElement(), cell.getColumnIndex()));
    }
}

