
/*------------------------------------------------------------------------
    File        : delete_instance.p
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Fri Dec 08 12:38:57 CET 2023
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */

block-level on error undo, throw.

using Progress.Lang.*.
using adm.method.cls.*.

/* ********************  Preprocessor Definitions  ******************** */

&GLOBAL-DEFINE pa-XBasisName              rename_instance_p

&SCOPED-DEFINE K_MESSAGE_TYPE_INFO        'Info':U
&SCOPED-DEFINE K_MESSAGE_TYPE_WARNING     'Warning':U
&SCOPED-DEFINE K_MESSAGE_TYPE_ERROR       'Error':U

/* ***************************  Main Block  *************************** */

define input  parameter gpcRequest  as character no-undo.
define output parameter gopclResult as longchar  no-undo.

define variable giMessageSequence     as integer   no-undo.
define variable glSuppressAllMessages as logical   no-undo.

{adm/repos/incl/dr_cls80.pds
  &ippNoReferenceOnlySwitch = "yes"
}

define temp-table ttMessage no-undo
  serialize-name 'Message':U
  
  field MessageId     as integer
    serialize-hidden
  field MessageType   as character
    serialize-name 'Type':U
    xml-node-type 'attribute':U
  field MessageText   as character
    serialize-name 'Text':U
  
  index Main is primary unique
    MessageId
  
  .

define dataset dsResult
  serialize-name 'Result':U
  for ttMessage
  .

assign
  glSuppressAllMessages = DMCMessageSvc:prpoInstance:prplSuppressAllMessages
  DMCMessageSvc:prpoInstance:prplSuppressAllMessages = yes
  .

run processRequest.

dataset dsResult:write-xml( 'longchar':U, gopclResult, no ).

catch oError as Error :
  run addMessagesFromError( oError ).
end catch.

finally:
  DMCMessageSvc:prpoInstance:prplSuppressAllMessages = glSuppressAllMessages.
end finally.

/* **********************  Internal Procedures  *********************** */

procedure addMessage :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcMessageType                                                              */
/* pcMessageText                                                              */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcMessageType as character no-undo.
define input parameter pcMessageText as character no-undo.

define buffer bttMessage for temp-table ttMessage.

create bttMessage.

assign
  giMessageSequence          = giMessageSequence + 1
  bttMessage.MessageId   = giMessageSequence
  bttMessage.MessageType = pcMessageType
  bttMessage.MessageText = pcMessageText
  .

validate bttMessage.


end procedure.


procedure addMessagesFromError :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* poError                                                                    */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter poError as Error no-undo.

define variable iErrorCounter as integer   no-undo.

do iErrorCounter = 1 to poError:NumMessages:
  run addMessage({&K_MESSAGE_TYPE_ERROR}, poError:GetMessage( iErrorCounter ) ).
end.
 
end procedure.

procedure fillDataset :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDRC_Instance_Obj                                                         */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDRC_Instance_Obj as character no-undo.

{call
  dsDR_Class_new
  emptyDataset}.

DMCSessionSvc:setObjectProperty( dataset dsDR_Class_new:handle,
                                 'ttDRC_InstanceAddPrepareString':U,
                                 substitute( 'and DRC_Instance.DRC_Instance_Obj = &1':U,
                                             quoter( pcDRC_Instance_Obj ) ) ).

{call
  dsDR_Class_new
  fillDataset}.

end procedure.

procedure processRequest :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define buffer bttDRC_Instance   for temp-table ttDRC_Instance.

define variable cDRC_Instance_Obj as character no-undo.

if not {fnarg
         pa_lReposIsInstanceExisting
         "gpcRequest"} then
  return.

cDRC_Instance_Obj = {fnarg
                      pa_cReposInstanceInformationByName
                      "gpcRequest,
                       'DRC_Instance_Obj':U"}.

run fillDataset( cDRC_Instance_Obj ).

{call
  dsDR_Class_new
  ModifyTrackingChanges
  yes}.

find bttDRC_Instance
  where bttDRC_Instance.DRC_Instance_Obj = cDRC_Instance_Obj.

delete bttDRC_Instance.

{call
  dsDR_Class_new
  SaveChanges}.

end procedure.
