
/*------------------------------------------------------------------------
    File        : get_instance_config.p
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Fri May 09 11:01:29 CEST 2025
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */

block-level on error undo, throw.

/* ********************  Preprocessor Definitions  ******************** */

&GLOBAL-DEFINE pa-XBasisName  get_instance_config_p

&SCOPED-DEFINE ppDatasetName  dsDR_ConfigTreeData

/* ***************************  Main Block  *************************** */

using adm.method.cls.DMCSessionSvc.
using adm.method.cls.DMCUISvc.

define input  parameter gpclRequest   as longchar no-undo.
define output parameter gopclResponse as longchar no-undo.

define temp-table ttRequest no-undo
  serialize-name 'Request':U
  field InstanceName             as character
  field DisplayMode              as character
  field ShowMenuItems            as logical
  field ShowOnlyConfigElements   as logical
  field ConfigElementColor       as integer
  field ConfigElementParentColor as integer
  
  index Main is primary unique
    InstanceName
  
  .

define dataset dsRequest
  serialize-hidden
  for ttRequest
  .

{adm/repos/incl/dr_ctd00.pds &ippNoReferenceOnlySwitch = "yes"}

run createResponse.

/* **********************  Internal Procedures  *********************** */

procedure createResponse :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

dataset dsRequest:read-xml('longchar':U, gpclRequest, 'EMPTY':U, ?, ? ).

run fillDataset.

dataset dsDR_ConfigTreeData:write-xml('longchar':U, gopclResponse, no).

end procedure.


procedure fillDataset :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define variable cInstanceObj  as character no-undo.

define buffer bttRequest for temp-table ttRequest.

find first bttRequest.

if not {fnarg
         pa_lReposIsInstanceExisting
         "bttRequest.InstanceName"} then
  return.

cInstanceObj = {fnarg
                 pa_cReposInstanceInformationByName
                 "bttRequest.InstanceName,
                  'DRC_Instance_Obj':U"}.

DMCSessionSvc:setObjectProperty(dataset {&ppDatasetName}:handle, 'ReferenceObj':U, cInstanceObj).
DMCSessionSvc:setObjectProperty(dataset {&ppDatasetName}:handle, 'DisplayMode':U, bttRequest.DisplayMode).
DMCSessionSvc:setObjectProperty(dataset {&ppDatasetName}:handle, 'ShowOnlyConfigElements':U, bttRequest.ShowOnlyConfigElements).
DMCSessionSvc:setObjectProperty(dataset {&ppDatasetName}:handle, 'ShowMenuItems':U, bttRequest.ShowMenuItems).

DMCSessionSvc:setObjectProperty(dataset {&ppDatasetName}:handle, 'NodeColorConfigElement':U, bttRequest.ConfigElementColor).
DMCSessionSvc:setObjectProperty(dataset {&ppDatasetName}:handle, 'NodeColorWithConfig':U, bttRequest.ConfigElementParentColor).

{call
  {&ppDatasetName}
  fillDataset}.

end procedure.
