
/*------------------------------------------------------------------------
    File        : start_gitcontrol.p
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Mon Oct 07 16:36:06 CEST 2024
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */

block-level on error undo, throw.

define input  parameter gpcQualifiedProcedureName as character no-undo.

/* ********************  Preprocessor Definitions  ******************** */

/* ************************  Function Prototypes ********************** */

function hRunningGitControlInstance returns handle 
  ( pcAbsolutePath as character ) forward.

/* ***************************  Main Block  *************************** */

run startGitControl(gpcQualifiedProcedureName).

/* **********************  Internal Procedures  *********************** */

procedure startGitControl :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcQualifiedProcedureName as character no-undo.

define variable hProcedure    as handle    no-undo.

hProcedure = hRunningGitControlInstance(pcQualifiedProcedureName).

if not valid-handle(hProcedure) then
do:

  do
    on error undo, throw:

    dynamic-invoke('edevsuite.cls.EDevSuiteSvc':U, 'initialize':U).

    catch oError as Progress.Lang.Error:

      /* Catch the following errors:                          */
      /* 14457: Method with matching signature does not exist */
      /* 15320: Method is non-static                          */
      if oError:GetMessageNum(1) <> 14457
        and oError:GetMessageNum(1) <> 15320 then
        undo, throw oError.

    end.
    
  end.

  run edevsuite/proc/edevsuite_git_control.w persistent set hProcedure.
  
end.

run moveWindowToTop in hProcedure.

end procedure.


/* ************************  Function Implementations ***************** */

function hRunningGitControlInstance returns handle 
  ( pcAbsolutePath as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define variable hProcedure as handle    no-undo.

hProcedure = session:first-procedure.

do while valid-handle(hProcedure):
  
  if hProcedure:name = pcAbsolutePath then
    return hProcedure.
  
  hProcedure = hProcedure:next-sibling.
    
end.

return ?.

end function.
