
/*------------------------------------------------------------------------
    File        : run_abl_procedure.p
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Tue Dec 12 08:07:47 CET 2023
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */

block-level on error undo, throw.

using Progress.Lang.*.

/* ********************  Preprocessor Definitions  ******************** */

/* ************************  Function Prototypes ********************** */

function cQualifiedNameOrNull returns character 
  ( pcAbsoluteProgramName as character ) forward.

function cRemoveFileExtension returns character 
  (pcFilename as character) forward.

/* ***************************  Main Block  *************************** */

define input  parameter gpcRequest as character  no-undo.

define variable ghDummyWindow as handle    no-undo.

do on error undo, throw:
  
  run createDummyWindow.
  
  if gpcRequest matches '*~.cls':U then
    
    run runClass( gpcRequest ).
    
  else
    
    run value( gpcRequest ).
  
  catch oError as Error :
    run showError( oError ).
  end catch.
  
  finally:
    delete object ghDummyWindow no-error.
  end finally.
  
end.

/* **********************  Internal Procedures  *********************** */

procedure createDummyWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Create hidden dummy window to prevent the progress default window to be    */
/* shown alongside dialogs.                                                   */
create window ghDummyWindow.


assign
  ghDummyWindow:visible       = no
  ghDummyWindow:always-on-top = yes
  /* We center the window on the screen since the default location is kind of */
  /* random and the dialogs that use this window as parent will be shown      */
  /* centered to this window.                                                 */
  ghDummyWindow:x = ( session:width-pixels - ghDummyWindow:width-pixels ) / 2
  ghDummyWindow:y = ( session:height-pixels - ghDummyWindow:height-pixels ) / 2
  .

current-window = ghDummyWindow.

end procedure.

procedure runClass :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcAbsoluteClassName as character no-undo.

define variable cQualifiedClassName    as character no-undo.
define variable oRequestObjectInstance as Object    no-undo.

assign
  cQualifiedClassName = cQualifiedNameOrNull( pcAbsoluteClassName )
  cQualifiedClassName = cRemoveFileExtension( cQualifiedClassName )
  cQualifiedClassName = replace( cQualifiedClassName, '/':U, '.':U )
  .

oRequestObjectInstance = dynamic-new cQualifiedClassName ().

finally:
  if valid-object( oRequestObjectInstance ) then
    delete object oRequestObjectInstance.
end finally.

end procedure.

procedure showError :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter poError as Error no-undo.

define variable iErrorCounter as integer   no-undo.

do iErrorCounter = 1 to poError:NumMessages:
  
  message
    poError:GetMessage(iErrorCounter) skip
    view-as alert-box
    error
    buttons ok
    in window ghDummyWindow.
  
end.

end procedure. /* showError */

/* ************************  Function Implementations ***************** */

function cQualifiedNameOrNull returns character 
  ( pcAbsoluteProgramName as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define variable cPropath             as character no-undo.
define variable cPropathEntry        as character no-undo.
define variable iPropathEntryCounter as integer   no-undo.

assign
  pcAbsoluteProgramName = replace( pcAbsoluteProgramName, '\':U, '/':U )
  cPropath              = propath
  .

do iPropathEntryCounter = 1 to num-entries( cPropath ):
  
  cPropathEntry = replace( entry( iPropathEntryCounter, cPropath ), '\':U, '/':U ).
  
  if pcAbsoluteProgramName begins cPropathEntry then
    return left-trim( substring( pcAbsoluteProgramName, length( cPropathEntry ) + 1 ), '/':U ).
  
end.

return ?.

end function. /* cQualifiedNameOrNull */

function cRemoveFileExtension returns character 
  ( pcFilename as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define variable iDotPos   as integer   no-undo.

iDotPos = r-index( pcFilename, '.':U ).

if iDotPos > max( r-index( pcFilename, '/':U ), r-index( pcFilename, '\':U ) ) then
  
  return substring( pcFilename, 1, iDotPos - 1 ).

return pcFilename.

end function. /* cRemoveFileExtension */
