&ANALYZE-SUSPEND _VERSION-NUMBER AB_v10r12
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DECLARATIONS Procedure 
routine-level on error undo, throw.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DEFINITIONS Procedure 
/*****************************************************************************/
/*                                     (c) 2008   proALPHA Software AG       */
/*                                                Auf dem Immel 8            */
/*                                                67685 Weilerbach           */
/*                                                                           */
/*  erstellt am: 20.02.2014                                                  */
/*  Autor......: Manuel Thiemann                                             */
/*                                                                           */
/*  Version....: 5.2b vom 12.12.2007/je                                      */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/*  AUFGABE                                                                  */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*  Get class info.                                                          */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/*  NDERUNGSPROTOKOLL                                                       */
/*---------------------------------------------------------------------------*/
/*  Datum    KZ  Beschreibung                                                */
/*---------------------------------------------------------------------------*/
/*****************************************************************************/

/*---------------------------------------------------------------------------*/
/* Definitionen                                                              */
/*---------------------------------------------------------------------------*/

define input  parameter gpcParameter     as character no-undo.
define output parameter gopclReturnValue as longchar  no-undo.

/* KONSTANTEN ---------------------------------------------------------------*/
/* Systemkonstanten **********************************************************/

/* lokale Konstanten *********************************************************/

/* EXTERNE DEFINITIONEN -----------------------------------------------------*/

/* Parameter ----------------------------------------------------------------*/

/* LOKALE OBJEKTE -----------------------------------------------------------*/

/* Variable ******************************************************************/

define variable giClass            as integer   no-undo.
define variable gcClassName        as character no-undo.

define variable goPropertyFlags    as Progress.Reflect.Flags no-undo.
define variable goMethodFlags      as Progress.Reflect.Flags no-undo.
define variable goConstructorFlags as Progress.Reflect.Flags no-undo.

/* Buffer ********************************************************************/

/* Work-/Temp-Tables *********************************************************/

define temp-table ttClass no-undo
  serialize-name 'Class':U
  field PackageName    as character
    serialize-name 'Package':u
    xml-node-type 'attribute':U
  field ClassName      as character
    serialize-name 'Name':u
    xml-node-type 'attribute':U
  field Filename as character
    xml-node-type 'attribute':U
  field DetailsError   as logical
    xml-node-type 'attribute':U
  field SuperClassName as character
    serialize-name 'SuperClass':u
    xml-node-type 'attribute':U
  field IsAbstract as logical
    xml-node-type 'attribute':U
  field IsEnum as logical
    xml-node-type 'attribute':U
  field IsFinal as logical
    xml-node-type 'attribute':U
  field IsFlagsEnum as logical
    xml-node-type 'attribute':U
  field IsInterface as logical
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    .

define temp-table ttClassDescription no-undo
  serialize-name 'Description':U
  field ClassName        as character
    serialize-hidden
  field Language         as character
    xml-node-type 'attribute':U
  field ShortDescription as character
  field Description      as character
  index Main is primary unique
    ClassName
    Language
    .

define temp-table ttProperty no-undo
  serialize-name 'Property':U
  field ClassName as character
  serialize-hidden
  field PropertyName as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field DataType         as character
    xml-node-type 'attribute':U
  field DataTypeName     as character
    xml-node-type 'attribute':U
  field Extent           as integer
    xml-node-type 'attribute':U
  field AccessMode       as character
    xml-node-type 'attribute':U
  field IsStatic         as logical
    xml-node-type 'attribute':U
  field CanRead          as logical
    xml-node-type 'attribute':U
  field CanWrite         as logical
    xml-node-type 'attribute':U
  field GetterAccessMode as character
    xml-node-type 'attribute':U
  field SetterAccessMode as character
    xml-node-type 'attribute':U
  field DeclaringClass   as character
    xml-node-type "attribute"
  field OriginatingClass as character
    xml-node-type "attribute"
  index Main is primary unique
    ClassName
    PropertyName
    DeclaringClass
    .

define temp-table ttConstructor no-undo
  serialize-name 'Constructor':U
  field ClassName        as character
    serialize-hidden
  field ConstructorName       as character
    xml-node-type 'attribute':U
    serialize-name 'Name':U
  field ConstructorIndex as integer
    serialize-name 'Index':U
    xml-node-type 'attribute':U
  field OriginatingClass as character
    xml-node-type "attribute"
  field AccessMode       as character
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    ConstructorIndex
    .

define temp-table ttConstructorParameter no-undo
  serialize-name 'Parameter':U
  field ClassName        as character
    serialize-hidden
  field ConstructorIndex as integer
    serialize-hidden
  field ParameterName    as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field Position         as integer
    xml-node-type 'attribute':U
  field DataType         as character
    xml-node-type 'attribute':U
  field DataTypeName     as character
    xml-node-type 'attribute':U
  field Extent           as integer
    xml-node-type 'attribute':U
  field Mode             as character
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    ConstructorIndex
    Position
  .

define temp-table ttMethod no-undo
  serialize-name 'Method':U
  field ClassName        as character
    serialize-hidden
  field MethodName       as character
    xml-node-type 'attribute':U
    serialize-name 'Name':U
  field MethodIndex      as integer
    xml-node-type 'attribute':U
    serialize-name 'Index':U
  field DeclaringClass   as character
    xml-node-type "attribute"
  field OriginatingClass as character
    xml-node-type "attribute"
  field IsStatic         as logical
    xml-node-type 'attribute':U
  field IsAbstract       as logical
    xml-node-type 'attribute':U
  field IsFinal          as logical
    xml-node-type 'attribute':U
  field AccessMode       as character
    xml-node-type 'attribute':U
  field ReturnType       as character
    xml-node-type 'attribute':U
  field ReturnTypeName   as character
    xml-node-type 'attribute':U
  field ReturnExtent     as integer
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    MethodIndex
    .

define temp-table ttMethodParameter no-undo
  serialize-name 'Parameter':U
  field ClassName     as character
    serialize-hidden
  field MethodIndex   as integer
    serialize-hidden
  field ParameterName as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field Position      as integer
    xml-node-type 'attribute':U
  field DataType      as character
    xml-node-type 'attribute':U
  field DataTypeName  as character
    xml-node-type 'attribute':U
  field Extent        as integer
    xml-node-type 'attribute':U
  field Mode          as character
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    MethodIndex
    Position
    .

/* Datasets ******************************************************************/

define dataset dsClasses
  serialize-name 'Classes':U

  for ttClass, ttClassDescription, ttConstructor, ttConstructorParameter,
    ttProperty, ttMethod, ttMethodParameter
  
  data-relation drDescription for ttClass, ttClassDescription nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drConstructor for ttClass, ttConstructor nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drConstructorParameter for ttConstructor, ttConstructorParameter nested
    relation-fields ( ClassName, ClassName, ConstructorIndex, ConstructorIndex )

  data-relation drProperty for ttClass, ttProperty nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drMethod for ttClass, ttMethod nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drMethodParameter for ttMethod, ttMethodParameter nested
    relation-fields ( ClassName, ClassName, MethodIndex, MethodIndex )
  
  .

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-PREPROCESSOR-BLOCK 

/* ********************  Preprocessor Definitions  ******************** */

&Scoped-define PROCEDURE-TYPE Procedure
&Scoped-define DB-AWARE no



/* _UIB-PREPROCESSOR-BLOCK-END */
&ANALYZE-RESUME


/* ************************  Function Prototypes ********************** */

&IF DEFINED(EXCLUDE-cClassPackage) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD cClassPackage Procedure 
FUNCTION cClassPackage returns character
  ( pcClassName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-cFileBody) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD cFileBody Procedure 
FUNCTION cFileBody returns character
  ( pcFileName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF


/* *********************** Procedure Settings ************************ */

&ANALYZE-SUSPEND _PROCEDURE-SETTINGS
/* Settings for THIS-PROCEDURE
   Type: Procedure
   Allow: 
   Frames: 0
   Add Fields to: Neither
   Other Settings: CODE-ONLY COMPILE
 */
&ANALYZE-RESUME _END-PROCEDURE-SETTINGS

/* *************************  Create Window  ************************** */

&ANALYZE-SUSPEND _CREATE-WINDOW
/* DESIGN Window definition (used by the UIB) 
  CREATE WINDOW Procedure ASSIGN
         HEIGHT             = 15
         WIDTH              = 60.
/* END WINDOW DEFINITION */
                                                                        */
&ANALYZE-RESUME

 


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _MAIN-BLOCK Procedure 


/* ***************************  Main Block  *************************** */

assign
  goPropertyFlags    =     Progress.Reflect.Flags:Public
                        or Progress.Reflect.Flags:Protected
                        or Progress.Reflect.Flags:Private
                        or Progress.Reflect.Flags:Static
                        or Progress.Reflect.Flags:Instance
  goMethodFlags      =     Progress.Reflect.Flags:Public
                        or Progress.Reflect.Flags:Protected
                        or Progress.Reflect.Flags:Private
                        or Progress.Reflect.Flags:Static
                        or Progress.Reflect.Flags:Instance
  goConstructorFlags =     Progress.Reflect.Flags:Public
                        or Progress.Reflect.Flags:Protected
                        or Progress.Reflect.Flags:Private
                        or Progress.Reflect.Flags:Instance
  .

if gpcParameter > '':U then
do:
  
  do giClass = 1 to num-entries( gpcParameter ):
    
    gcClassName = entry( giClass, gpcParameter ).
    
    if not gcClassName matches '*~.cls':U then
      gcClassName = substitute( '&1.cls':U, gcClassName ).
    
    find DRC_Instance
      where DRC_Instance.DRC_Instance_ID = gcClassName
      no-lock.
    
    run addClass( buffer DRC_Instance, yes ).
    
  end. /* do giClass = 1 to num-entries( gpcParameter ) */
  
end.

else
do:
  
  for each DRC_Instance
    where DRC_Instance.DRC_Instance_ID matches '*.cls':U
    no-lock
    on error undo, throw:

    run addClass( buffer DRC_Instance, no ).

  end. /* for each DRC_Instance */
  
end. /* else: if gpcParameter > '':U */

dataset dsClasses:write-xml( 'longchar':U, gopclReturnValue, yes ).

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* **********************  Internal Procedures  *********************** */

&IF DEFINED(EXCLUDE-addClass) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addClass Procedure 
PROCEDURE addClass :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbDRC_Instance for DRC_Instance.

define input parameter plAddDetails as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hQuery          as handle    no-undo.
define variable hInstanceBuffer as handle    no-undo.

define variable cPackageName    as character no-undo.
define variable cClassName      as character no-undo.

define variable oClass          as progress.lang.class          no-undo.
define variable oSuperClass     as progress.lang.class          no-undo.

define variable oConstructors   as progress.reflect.constructor no-undo extent.
define variable iConstructor    as integer   no-undo.

define variable oProperties     as Progress.Reflect.Property    no-undo extent.
define variable iProperty       as integer   no-undo.

define variable oMethods        as progress.reflect.method      no-undo extent.
define variable iMethod         as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bDBM_ShortDescription for DBM_ShortDescription.

define buffer bttClass              for temp-table ttClass.
define buffer bttClassDescription   for temp-table ttClassDescription.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cClassName   = cFileBody( pbDRC_Instance.DRC_Instance_ID )
  cPackageName = cClassPackage( cClassName )
  .

create bttClass.

assign
  bttClass.PackageName = cPackageName
  bttClass.ClassName   = cClassName
  bttClass.Filename    = ( if cPackageName > '':U then
                            substitute( '&1/&2':U,
                                        replace( cPackageName, '.':U, '/':U ),
                                        pbDRC_Instance.DRC_Instance_ID )
                           else
                             pbDRC_Instance.DRC_Instance_ID )
  .

/* Add description. */

for each bDBM_ShortDescription
  where bDBM_ShortDescription.Owning_Obj = pbDRC_Instance.DRC_Instance_Obj
  no-lock
  on error undo, throw:
  
  create bttClassDescription.
  
  assign
    bttClassDescription.ClassName        = bttClass.ClassName
    bttClassDescription.Language         = bDBM_ShortDescription.Sprache
    bttClassDescription.ShortDescription = bDBM_ShortDescription.ShortDesc1
    .
  
  validate bttClassDescription.
  
end. /* for each bDBM_ShortDescription */

if plAddDetails then
Details:
do:
  
  oClass = progress.lang.Class:getClass( if cPackageName > '':U then
                                           substitute( '&1.&2':U, cPackageName, cClassName )
                                         else
                                           cClassName ) no-error.
  
  if error-status:error then
  do:
    
    bttClass.DetailsError = yes.
    leave Details.
    
  end. /* if error-status:error */
  
  oSuperClass = oClass:SuperClass.
  
  if valid-object( oSuperClass ) then
    bttClass.SuperClassName = oSuperClass:TypeName.
  
  assign
    bttClass.IsAbstract  = oClass:IsAbstract()
    bttClass.IsEnum      = oClass:IsEnum()
    bttClass.IsFinal     = oClass:IsFinal()
    bttClass.IsFlagsEnum = oClass:IsFlagsEnum()
    bttClass.IsInterface = oClass:IsInterface()
    .
  
  /* Add Properties */
  
  oProperties = oClass:GetProperties( goPropertyFlags ).
  
  do iProperty = 1 to extent( oProperties ):
    
    run addProperty( bttClass.ClassName,
                     oProperties[iProperty] ).
    
  end. /* do iProperty = 1 to extent( oProperties ) */
  
  /* Add constructors */
  
  oConstructors = oClass:GetConstructors( goConstructorFlags ).
  
  do iConstructor = 1 to extent( oConstructors ):
    
    run addConstructor( bttClass.ClassName,
                        iConstructor,
                        oConstructors[iConstructor] ).
    
  end. /* do iConstructor = 1 to extent( oConstructors ) */
  
  /* Add methods */
  
  oMethods = oClass:GetMethods( goMethodFlags ).
  
  do iMethod = 1 to extent( oMethods ):
    
    run addMethod( bttClass.ClassName,
                   iMethod,
                   oMethods[iMethod] ).
    
  end. /* do iMethod = 1 to extent( oMethods ) */

end. /* if plAddDetails */

validate bttClass.

/*catch oError as progress.lang.error:          */
/*                                              */
/*  return.                                     */
/*                                              */
/*end. /* catch oError as progress.lang.error */*/

end procedure. /* addClass */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-addConstructor) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addConstructor Procedure 
PROCEDURE addConstructor :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName        as character no-undo.
define input parameter piConstructorIndex as integer   no-undo.

define input parameter poConstructor as progress.reflect.constructor no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oOriginatingClass as Progress.Lang.Class         no-undo.
define variable oAccessMode       as progress.reflect.accessmode no-undo.

define variable oPrameters        as progress.reflect.parameter  no-undo extent.
define variable iParameter        as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttConstructor for temp-table ttConstructor.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttConstructor.

assign
  bttConstructor.ClassName        = pcClassName
  bttConstructor.ConstructorIndex = piConstructorIndex
  bttConstructor.ConstructorName  = poConstructor:Name
  oOriginatingClass               = poConstructor:OriginatingClass
  oAccessMode                     = poConstructor:AccessMode
  .

if valid-object( oOriginatingClass ) then
  bttConstructor.OriginatingClass = oOriginatingClass:TypeName.

if valid-object( oAccessMode ) then
  bttConstructor.AccessMode = oAccessMode:toString().
  .

validate bttConstructor.

oPrameters = poConstructor:GetParameters().

do iParameter = 1 to extent( oPrameters ):
  
  run addConstructorParameter( bttConstructor.ClassName,
                               bttConstructor.ConstructorIndex,
                               oPrameters[iParameter] ).
  
end. /* do iParameter = 1 to extent( oPrameters ) */

end procedure. /* addConstructor */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-addConstructorParameter) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addConstructorParameter Procedure 
PROCEDURE addConstructorParameter :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName        as character no-undo.
define input parameter piConstructorIndex as integer   no-undo.

define input parameter poParameter   as progress.reflect.parameter no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oDataType  as progress.reflect.datatype      no-undo.
define variable oMode      as progress.reflect.parametermode no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttConstructorParameter for temp-table ttConstructorParameter.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttConstructorParameter.

assign
  bttConstructorParameter.ClassName        = pcClassName
  bttConstructorParameter.ConstructorIndex = piConstructorIndex
  bttConstructorParameter.Position         = poParameter:Position
  bttConstructorParameter.ParameterName    = poParameter:Name
  bttConstructorParameter.DataTypeName     = poParameter:DataTypeName
  bttConstructorParameter.Extent           = poParameter:Extent
  oDataType                                = poParameter:DataType
  oMode                                    = poParameter:Mode
  .

if valid-object( oDataType ) then
  bttConstructorParameter.DataType = oDataType:toString().

if valid-object( oMode ) then
  bttConstructorParameter.Mode = oMode:toString().

validate bttConstructorParameter.

end procedure. /* addConstructorParameter */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-addMethod) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addMethod Procedure 
PROCEDURE addMethod :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName   as character no-undo.
define input parameter piMethodIndex as integer   no-undo.

define input parameter poMethod      as progress.reflect.method no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oOriginatingClass as Progress.Lang.Class         no-undo.
define variable oDeclaringClass   as Progress.Lang.Class         no-undo.
define variable oReturnType       as progress.reflect.datatype   no-undo.
define variable oAccessMode       as progress.reflect.accessmode no-undo.

define variable oPrameters        as progress.reflect.parameter  no-undo extent.
define variable iParameter        as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttMethod for temp-table ttMethod.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttMethod.

assign
  bttMethod.ClassName      = pcClassName
  bttMethod.MethodIndex    = piMethodIndex
  bttMethod.MethodName     = poMethod:Name
  bttMethod.IsStatic       = poMethod:IsStatic
  bttMethod.IsAbstract     = poMethod:IsAbstract
  bttMethod.IsFinal        = poMethod:IsFinal
  bttMethod.ReturnTypeName = poMethod:ReturnTypeName
  bttMethod.ReturnExtent   = poMethod:ReturnExtent
  oDeclaringClass          = poMethod:DeclaringClass
  oOriginatingClass        = poMethod:OriginatingClass
  oReturnType              = poMethod:ReturnType
  oAccessMode              = poMethod:AccessMode
  .

if valid-object( oDeclaringClass ) then
  bttMethod.DeclaringClass = oDeclaringClass:TypeName.

if valid-object( oOriginatingClass ) then
  bttMethod.OriginatingClass = oOriginatingClass:TypeName.

if valid-object( oReturnType ) then
  bttMethod.ReturnType = oReturnType:toString().

if valid-object( oAccessMode ) then
  bttMethod.AccessMode = oAccessMode:toString().
  .

validate bttMethod.

oPrameters = poMethod:GetParameters().

do iParameter = 1 to extent( oPrameters ):
  
  run addMethodParameter( bttMethod.ClassName,
                          bttMethod.MethodIndex,
                          oPrameters[iParameter] ).
  
end. /* do iParameter = 1 to extent( oPrameters ) */

end procedure. /* addMethod */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-addMethodParameter) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addMethodParameter Procedure 
PROCEDURE addMethodParameter :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName   as character no-undo.
define input parameter piMethodIndex as integer   no-undo.

define input parameter poParameter   as progress.reflect.parameter no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oDataType  as progress.reflect.datatype      no-undo.
define variable oMode      as progress.reflect.parametermode no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttMethodParameter for temp-table ttMethodParameter.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttMethodParameter.

assign
  bttMethodParameter.ClassName     = pcClassName
  bttMethodParameter.MethodIndex   = piMethodIndex
  bttMethodParameter.Position      = poParameter:Position
  bttMethodParameter.ParameterName = poParameter:Name
  bttMethodParameter.DataTypeName  = poParameter:DataTypeName
  bttMethodParameter.Extent        = poParameter:Extent
  oDataType                        = poParameter:DataType
  oMode                            = poParameter:Mode
  .

if valid-object( oDataType ) then
  bttMethodParameter.DataType = oDataType:toString().

if valid-object( oMode ) then
  bttMethodParameter.Mode = oMode:toString().

validate bttMethodParameter.

end procedure. /* addMethodParameter */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-addProperty) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addProperty Procedure 
PROCEDURE addProperty :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName   as character no-undo.

define input parameter poProperty    as progress.reflect.property no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oDataType         as progress.reflect.datatype   no-undo.
define variable oAccessMode       as progress.reflect.accessmode no-undo.
define variable oGetterAccessMode as progress.reflect.accessmode no-undo.
define variable oSetterAccessMode as progress.reflect.accessmode no-undo.
define variable oOriginatingClass as Progress.Lang.Class         no-undo.
define variable oDeclaringClass   as Progress.Lang.Class         no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttProperty for temp-table ttProperty.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttProperty.

assign
  bttProperty.ClassName    = pcClassName
  bttProperty.PropertyName = poProperty:Name
  bttProperty.DataTypeName = poProperty:DataTypeName
  bttProperty.Extent       = poProperty:Extent
  bttProperty.IsStatic     = poProperty:IsStatic
  bttProperty.CanRead      = poProperty:CanRead
  bttProperty.CanWrite     = poProperty:CanWrite
  oDataType                = poProperty:DataType
  oAccessMode              = poProperty:AccessMode
  oGetterAccessMode        = poProperty:GetterAccessMode
  oSetterAccessMode        = poProperty:SetterAccessMode
  oOriginatingClass        = poProperty:OriginatingClass
  oDeclaringClass          = poProperty:DeclaringClass
  .

if valid-object ( oDataType ) then
  bttProperty.DataType = oDataType:toString().

if valid-object( oAccessMode ) then
  bttProperty.AccessMode = oAccessMode:toString().

if valid-object( oGetterAccessMode ) then
  bttProperty.GetterAccessMode = oGetterAccessMode:toString().

if valid-object( oSetterAccessMode ) then
  bttProperty.SetterAccessMode = oSetterAccessMode:toString().

if valid-object( oOriginatingClass ) then
  bttProperty.OriginatingClass = oOriginatingClass:TypeName.

if valid-object( oDeclaringClass ) then
  bttProperty.DeclaringClass = oDeclaringClass:TypeName.

validate bttProperty.

end procedure. /* addProperty */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

/* ************************  Function Implementations ***************** */

&IF DEFINED(EXCLUDE-cClassPackage) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION cClassPackage Procedure 
FUNCTION cClassPackage returns character
  ( pcClassName as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cPackage as character no-undo.

define variable oMethods as progress.reflect.method        no-undo extent.

/* Buffers -------------------------------------------------------------------*/

define buffer bD_Modul      for D_Modul.
define buffer bD_UnterModul for D_UnterModul.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/    

find bD_Modul
  where bD_Modul.Kennbuchstabe = substring( pcClassName, 1, 1 )
  no-lock no-error.

if not available bD_Modul then
  return '':U.

if bD_Modul.Unterverzeichnis > '':U then
  cPackage = bD_Modul.Unterverzeichnis.

find bD_UnterModul
  where bD_UnterModul.ModulName     = bD_Modul.ModulName
    and bD_UnterModul.Kennbuchstabe = substring( pcClassName, 2, 1 ) 
  no-lock no-error.

if not available bD_UnterModul then
  return '':U.

if bD_UnterModul.Unterverzeichnis > '':U then
do:
  
  if cPackage > '':U then
    cPackage = cPackage + '.':U.
  
  cPackage = cPackage + bD_UnterModul.Unterverzeichnis.
  
end. /* if bD_UnterModul.Unterverzeichnis > '':U */

if cPackage > '':U then
  cPackage = cPackage + '.cls':U.

return cPackage.

end function. /* cClassPackage */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-cFileBody) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION cFileBody Procedure 
FUNCTION cFileBody returns character
  ( pcFileName as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iIndex as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/    

iIndex = r-index( pcFileName, '.':U ).

return ( if iIndex > 0 then
           substring( pcFileName, 1, iIndex - 1 )
         else
           pcFileName ).

end function. /* cFileBody */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

