/*
 * Decompiled with CFR 0.152.
 */
package selectionannotator.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import selectionannotator.annotations.AnnotationModelUtilities;
import selectionannotator.annotations.SelectionAnnotation;
import selectionannotator.preferences.PreferenceStore;

public abstract class TextEditorSelectionAnnotator {
    private static Pattern wordPattern;
    private static Pattern nonWordPattern;

    public static void updateAnnotations(ITextEditor textEditor) {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = textEditor.getDocumentProvider().getAnnotationModel((Object)textEditor.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        TextEditorSelectionAnnotator.updateAnnotations(document, selection, annotationModel);
    }

    public static void updateAnnotations(IDocument document, ISelection selection, IAnnotationModel annotationModel) {
        boolean createAnnotations = selection instanceof ITextSelection;
        if (createAnnotations) {
            ITextSelection textSelection = (ITextSelection)selection;
            boolean bl = createAnnotations = textSelection.getStartLine() == textSelection.getEndLine();
            if (createAnnotations) {
                String selectedText = textSelection.getText();
                boolean bl2 = createAnnotations = selectedText != null && !selectedText.isEmpty();
                if (createAnnotations) {
                    Collection<SelectionAnnotation> oldAnnotations = AnnotationModelUtilities.getAnnotations(annotationModel, SelectionAnnotation.class);
                    Map<SelectionAnnotation, Position> newAnnotations = TextEditorSelectionAnnotator.createAnnotations(document, textSelection);
                    AnnotationModelUtilities.replaceAnnotations(annotationModel, oldAnnotations, newAnnotations);
                }
            }
        }
        if (!createAnnotations && !PreferenceStore.getKeepAnnotations()) {
            AnnotationModelUtilities.deleteAnnotations(annotationModel, SelectionAnnotation.class);
        }
    }

    private static Map<SelectionAnnotation, Position> createAnnotations(IDocument document, ITextSelection textSelection) {
        String text = document.get();
        int maxTextLength = PreferenceStore.getMaxTextLength();
        if (maxTextLength != 0 && text.length() > maxTextLength) {
            return null;
        }
        String textSelectionString = textSelection.getText();
        if (PreferenceStore.getWholeWordsOnly() && !TextEditorSelectionAnnotator.isWholeWordsOnly(text, textSelectionString, textSelection)) {
            return null;
        }
        Pattern regexPattern = TextEditorSelectionAnnotator.getTextSelectionPattern(textSelectionString);
        Matcher regexMatcher = regexPattern.matcher(text);
        ArrayList<MatchResult> matchResults = new ArrayList<MatchResult>();
        while (regexMatcher.find()) {
            matchResults.add(regexMatcher.toMatchResult());
        }
        int matchCounter = 0;
        LinkedHashMap<SelectionAnnotation, Position> annotationMap = new LinkedHashMap<SelectionAnnotation, Position>();
        for (MatchResult matchResult : matchResults) {
            SelectionAnnotation annotation = new SelectionAnnotation(++matchCounter, matchResults.size());
            Position annotationPosition = new Position(matchResult.start(), matchResult.end() - matchResult.start());
            annotationMap.put(annotation, annotationPosition);
        }
        return annotationMap;
    }

    private static boolean isWholeWordsOnly(String text, String textSelectionString, ITextSelection textSelection) {
        Matcher wordMatcher;
        String wordCharacterRegex = PreferenceStore.getWordCharacterRegex();
        if (wordPattern == null) {
            String wordPatternRegex = "^[" + wordCharacterRegex + "]+$";
            wordPattern = Pattern.compile(wordPatternRegex, 256);
        }
        if (!(wordMatcher = wordPattern.matcher(textSelectionString)).matches()) {
            return false;
        }
        int selectionStartPosition = textSelection.getOffset();
        int selectionEndPostiion = selectionStartPosition + textSelection.getLength();
        String neighboringCharacters = "";
        if (selectionStartPosition > 0) {
            neighboringCharacters = String.valueOf(neighboringCharacters) + text.substring(selectionStartPosition - 1, selectionStartPosition);
        }
        if (selectionEndPostiion < text.length()) {
            neighboringCharacters = String.valueOf(neighboringCharacters) + text.substring(selectionEndPostiion, selectionEndPostiion + 1);
        }
        if (!neighboringCharacters.isEmpty()) {
            Matcher nonWordMatcher;
            if (nonWordPattern == null) {
                String nonWordPatternRegex = "(?s)^(?:(?![" + wordCharacterRegex + "]).)+$";
                nonWordPattern = Pattern.compile(nonWordPatternRegex, 256);
            }
            if (!(nonWordMatcher = nonWordPattern.matcher(neighboringCharacters)).matches()) {
                return false;
            }
        }
        return true;
    }

    private static Pattern getTextSelectionPattern(String textSelectionString) {
        String regexString = Pattern.quote(textSelectionString);
        if (!PreferenceStore.getCaseSensitive()) {
            regexString = "(?i)" + regexString + "(?-i)";
        }
        if (PreferenceStore.getWholeWordsOnly()) {
            String wordCharacterRegex = PreferenceStore.getWordCharacterRegex();
            regexString = String.valueOf(regexString) + "(?:(?<![" + wordCharacterRegex + "]" + regexString + ")" + "(?![" + wordCharacterRegex + "]))";
        }
        return Pattern.compile(regexString, 256);
    }

    public static void onWordCharacterRegexChanged() {
        wordPattern = null;
        nonWordPattern = null;
    }
}

