/*
 * Decompiled with CFR 0.152.
 */
package selectionannotator.preferences;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import selectionannotator.SelectionAnnotatorPlugin;
import selectionannotator.preferences.CheckableStringFieldEditor;
import selectionannotator.preferences.ICheckStateListener;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor wholeWordsOnlyPreference;
    private Composite wholeWordsOnlySubPreferences;

    public PreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SelectionAnnotatorPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite compositeParent = new Composite(this.getFieldEditorParent(), 0);
        compositeParent.setLayout((Layout)new GridLayout());
        compositeParent.setLayoutData((Object)new GridData(768));
        Group groupAnnotations = new Group(compositeParent, 0);
        groupAnnotations.setText("Annotations");
        groupAnnotations.setLayout((Layout)new GridLayout());
        groupAnnotations.setLayoutData((Object)new GridData(768));
        Composite compositeAnnotations = new Composite((Composite)groupAnnotations, 0);
        compositeAnnotations.setLayout((Layout)new GridLayout());
        compositeAnnotations.setLayoutData((Object)new GridData(768));
        this.wholeWordsOnlyPreference = new BooleanFieldEditor("WHOLE_WORDS_ONLY", "Whole words only", compositeAnnotations);
        this.addField((FieldEditor)this.wholeWordsOnlyPreference);
        this.wholeWordsOnlySubPreferences = new Composite(compositeAnnotations, 0);
        this.wholeWordsOnlySubPreferences.setLayout((Layout)new GridLayout(2, false));
        GridData wordsOnlySubPreferencesLayoutData = new GridData(768);
        wordsOnlySubPreferencesLayoutData.horizontalIndent = 20;
        this.wholeWordsOnlySubPreferences.setLayoutData((Object)wordsOnlySubPreferencesLayoutData);
        CheckableStringFieldEditor wordCharacterRegex = new CheckableStringFieldEditor("WORD_CHARACTER_REGEX", "Word character regex:", this.wholeWordsOnlySubPreferences);
        wordCharacterRegex.addCheckStateListener(new ICheckStateListener(){

            @Override
            public boolean checkState(StringFieldEditor editor) {
                return PreferencePage.this.isWordCharacterRegexValid(editor);
            }
        });
        this.addField((FieldEditor)wordCharacterRegex);
        this.addField((FieldEditor)new BooleanFieldEditor("CASE_SENSITIVE", "Case sensitive", compositeAnnotations));
        this.addField((FieldEditor)new BooleanFieldEditor("KEEP_ANNOTATIONS", "Keep annotations", compositeAnnotations));
        Link annotationLink = new Link(compositeAnnotations, 0);
        annotationLink.setText("<a>Change annotation style</a>");
        annotationLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PreferencePage.this.getShell(), (String)"org.eclipse.ui.editors.preferencePages.Annotations", null, (Object)"Selection Occurrences");
            }
        });
        Group groupFilter = new Group(compositeParent, 0);
        groupFilter.setText("Filter");
        groupFilter.setLayout((Layout)new GridLayout());
        groupFilter.setLayoutData((Object)new GridData(768));
        Composite compositeFilter = new Composite((Composite)groupFilter, 0);
        compositeFilter.setLayout((Layout)new GridLayout());
        compositeFilter.setLayoutData((Object)new GridData(768));
        this.addField((FieldEditor)new IntegerFieldEditor("MAX_TEXT_LENGTH", "Max text length (0 for unlimited):", compositeFilter, 10));
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateWholeWordsOnlySubPreferencesSensitivity();
        return contents;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value") && event.getSource() == this.wholeWordsOnlyPreference) {
            this.updateWholeWordsOnlySubPreferencesSensitivity();
        }
        super.propertyChange(event);
    }

    private void updateWholeWordsOnlySubPreferencesSensitivity() {
        Control[] controlArray = this.wholeWordsOnlySubPreferences.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(this.wholeWordsOnlyPreference.getBooleanValue());
            ++n2;
        }
    }

    private boolean isWordCharacterRegexValid(StringFieldEditor editor) {
        String input = editor.getStringValue();
        String errorMessage = null;
        if (input.isEmpty()) {
            errorMessage = "Enter a non-empty regular expression";
        } else {
            try {
                String regex = "[" + input + "]";
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                errorMessage = "Invalid regular expression for a character set";
            }
        }
        if (errorMessage != null) {
            editor.setErrorMessage(errorMessage);
            return false;
        }
        return true;
    }
}

