&ANALYZE-SUSPEND _VERSION-NUMBER AB_v10r12
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DECLARATIONS Procedure 
routine-level on error undo, throw.

using Progress.Lang.*.
using Progress.Reflect.*.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DEFINITIONS Procedure 
/*****************************************************************************/
/*                                     (c) 2008   proALPHA Software AG       */
/*                                                Auf dem Immel 8            */
/*                                                67685 Weilerbach           */
/*                                                                           */
/*  erstellt am: 20.02.2014                                                  */
/*  Autor......: Manuel Thiemann                                             */
/*                                                                           */
/*  Version....: 5.2b vom 12.12.2007/je                                      */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/*  AUFGABE                                                                  */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*  Get class info.                                                          */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/*  �NDERUNGSPROTOKOLL                                                       */
/*---------------------------------------------------------------------------*/
/*  Datum    KZ  Beschreibung                                                */
/*---------------------------------------------------------------------------*/
/*****************************************************************************/

/*---------------------------------------------------------------------------*/
/* Definitionen                                                              */
/*---------------------------------------------------------------------------*/

define input  parameter gpclRequest      as longchar  no-undo.
define output parameter gopclReturnValue as longchar  no-undo.

/* KONSTANTEN ---------------------------------------------------------------*/
/* Systemkonstanten **********************************************************/

/* lokale Konstanten *********************************************************/

/* EXTERNE DEFINITIONEN -----------------------------------------------------*/

/* Parameter ----------------------------------------------------------------*/

/* LOKALE OBJEKTE -----------------------------------------------------------*/

/* Variable ******************************************************************/

define variable giClass            as integer   no-undo.
define variable gcClassName        as character no-undo.

define variable goPropertyFlags    as Flags no-undo.
define variable goEventFlags       as Flags no-undo.
define variable goMethodFlags      as Flags no-undo.
define variable goConstructorFlags as Flags no-undo.

define variable gcSessionLanguage  as character no-undo init 'E':U.

/* Buffer ********************************************************************/

/* Work-/Temp-Tables *********************************************************/

/*define temp-table ttRequest no-undo*/

/* Input Parameter / Request Temp-Tables */

define temp-table ttRequestParameters no-undo
  
  serialize-name 'Parameters':U
  
  field Id          as integer
    serialize-hidden
  field CacheFilePath as character
  field LoadDetails   as logical
  
  index Main is primary unique
    Id
  
  .

define temp-table ttRequestClass no-undo
  
  serialize-name 'Class':U
  
  field ClassRelativeFilePath as character
    serialize-name 'RelativePath':U
  
  index Main is primary unique
    ClassRelativeFilePath
  
  .

/* Output Parameter / Class Info Temp-Tables */

define temp-table ttClass no-undo
  serialize-name 'Class':U
  field RelativeFilePath as character
    xml-node-type 'attribute':U
  field PackageName    as character
    serialize-name 'Package':u
    xml-node-type 'attribute':U
  field ClassName      as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field ClassTypeName as character
    serialize-name 'TypeName'
    xml-node-type 'attribute':U
  field DetailsLoaded  as logical
    xml-node-type 'attribute':U
  field DetailsError   as logical
    xml-node-type 'attribute':U
  field SuperClassName as character
    serialize-name 'SuperClass':u
    xml-node-type 'attribute':U
  field IsAbstract as logical
    xml-node-type 'attribute':U
  field IsEnum as logical
    xml-node-type 'attribute':U
  field IsFinal as logical
    xml-node-type 'attribute':U
  field IsFlagsEnum as logical
    xml-node-type 'attribute':U
  field IsInterface as logical
    xml-node-type 'attribute':U
  index Main is primary unique
    RelativeFilePath
    .

define temp-table ttClassDescription no-undo
  serialize-name 'Description':U
  field ClassName        as character
    serialize-hidden
  field Language         as character
    xml-node-type 'attribute':U
  field ShortDescription as character
  field Description      as character
  index Main is primary unique
    ClassName
    Language
    .

define temp-table ttProperty no-undo
  serialize-name 'Property':U
  field ClassName as character
    serialize-hidden
  field PropertyName as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field DataType         as character
    xml-node-type 'attribute':U
  field DataTypeName     as character
    xml-node-type 'attribute':U
  field Extent           as integer
    xml-node-type 'attribute':U
  field AccessMode       as character
    xml-node-type 'attribute':U
  field IsStatic         as logical
    xml-node-type 'attribute':U
  field CanRead          as logical
    xml-node-type 'attribute':U
  field CanWrite         as logical
    xml-node-type 'attribute':U
  field GetterAccessMode as character
    xml-node-type 'attribute':U
  field SetterAccessMode as character
    xml-node-type 'attribute':U
  field DeclaringClass   as character
    xml-node-type "attribute"
  field OriginatingClass as character
    xml-node-type "attribute"
  index Main is primary unique
    ClassName
    PropertyName
    DeclaringClass
    .

define temp-table ttEnumMember no-undo
  serialize-name 'EnumMember':U
  field ClassName as character
    serialize-hidden
  field EnumName  as character
    serialize-name 'Name':U
    xml-node-type "attribute"
  field EnumValue as int64
    serialize-name 'Value':U
    xml-node-type "attribute"
  index Main is primary unique
    ClassName
    EnumValue
    .

define temp-table ttEvent no-undo
  serialize-name 'Event':U
  field ClassName   as character
    serialize-hidden
  field EventName  as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field DeclaringClass   as character
    xml-node-type "attribute"
  field OriginatingClass as character
    xml-node-type "attribute"
  field AccessMode as character
    xml-node-type 'attribute':U
  field IsAbstract as logical
    xml-node-type 'attribute':U
  field IsOverride as logical
    xml-node-type 'attribute':U
  field IsStatic   as logical
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    EventName
    .

define temp-table ttEventParameter no-undo
  serialize-name 'Parameter':U
  field ClassName   as character
    serialize-hidden
  field EventName  as character
    serialize-hidden
  field ParameterName    as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field Position         as integer
    xml-node-type 'attribute':U
  field DataType         as character
    xml-node-type 'attribute':U
  field DataTypeName     as character
    xml-node-type 'attribute':U
  field Extent           as integer
    xml-node-type 'attribute':U
  field Mode             as character
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    EventName
    ParameterName
    .

define temp-table ttConstructor no-undo
  serialize-name 'Constructor':U
  field ClassName        as character
    serialize-hidden
  field ConstructorName       as character
    xml-node-type 'attribute':U
    serialize-name 'Name':U
  field ConstructorIndex as integer
    serialize-name 'Index':U
    xml-node-type 'attribute':U
  field OriginatingClass as character
    xml-node-type "attribute"
  field AccessMode       as character
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    ConstructorIndex
    .

define temp-table ttConstructorParameter no-undo
  serialize-name 'Parameter':U
  field ClassName        as character
    serialize-hidden
  field ConstructorIndex as integer
    serialize-hidden
  field ParameterName    as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field Position         as integer
    xml-node-type 'attribute':U
  field DataType         as character
    xml-node-type 'attribute':U
  field DataTypeName     as character
    xml-node-type 'attribute':U
  field Extent           as integer
    xml-node-type 'attribute':U
  field Mode             as character
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    ConstructorIndex
    Position
  .

define temp-table ttMethod no-undo
  serialize-name 'Method':U
  field ClassName        as character
    serialize-hidden
  field MethodName       as character
    xml-node-type 'attribute':U
    serialize-name 'Name':U
  field MethodIndex      as integer
    xml-node-type 'attribute':U
    serialize-name 'Index':U
  field DeclaringClass   as character
    xml-node-type "attribute"
  field OriginatingClass as character
    xml-node-type "attribute"
  field IsStatic         as logical
    xml-node-type 'attribute':U
  field IsAbstract       as logical
    xml-node-type 'attribute':U
  field IsFinal          as logical
    xml-node-type 'attribute':U
  field AccessMode       as character
    xml-node-type 'attribute':U
  field ReturnType       as character
    xml-node-type 'attribute':U
  field ReturnTypeName   as character
    xml-node-type 'attribute':U
  field ReturnExtent     as integer
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    MethodIndex
    .

define temp-table ttMethodParameter no-undo
  serialize-name 'Parameter':U
  field ClassName     as character
    serialize-hidden
  field MethodIndex   as integer
    serialize-hidden
  field ParameterName as character
    serialize-name 'Name':U
    xml-node-type 'attribute':U
  field Position      as integer
    xml-node-type 'attribute':U
  field DataType      as character
    xml-node-type 'attribute':U
  field DataTypeName  as character
    xml-node-type 'attribute':U
  field Extent        as integer
    xml-node-type 'attribute':U
  field Mode          as character
    xml-node-type 'attribute':U
  index Main is primary unique
    ClassName
    MethodIndex
    Position
    .

/* Datasets ******************************************************************/

/* Input Parameter / Class Info Dataset */

define dataset dsRequest
  
  serialize-name 'Request':U
  
  for ttRequestParameters,
      ttRequestClass
  
  .

/* Class Info Dataset*/

define dataset dsClasses
  serialize-name 'Classes':U

  for ttClass, ttClassDescription, ttConstructor, ttConstructorParameter,
    ttProperty, ttEnumMember, ttEvent, ttEventParameter, ttMethod, ttMethodParameter
  
  data-relation drDescription for ttClass, ttClassDescription nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drConstructor for ttClass, ttConstructor nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drConstructorParameter for ttConstructor, ttConstructorParameter nested
    relation-fields ( ClassName, ClassName, ConstructorIndex, ConstructorIndex )

  data-relation drProperty for ttClass, ttProperty nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drEnumMember for ttClass, ttEnumMember nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drEvent for ttClass, ttEvent nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drEventParameter for ttEvent, ttEventParameter nested
    relation-fields ( ClassName, ClassName, EventName, EventName )
  
  data-relation drMethod for ttClass, ttMethod nested
    relation-fields ( ClassName, ClassName )
  
  data-relation drMethodParameter for ttMethod, ttMethodParameter nested
    relation-fields ( ClassName, ClassName, MethodIndex, MethodIndex )
  
  .

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-PREPROCESSOR-BLOCK 

/* ********************  Preprocessor Definitions  ******************** */

&Scoped-define PROCEDURE-TYPE Procedure
&Scoped-define DB-AWARE no



/* _UIB-PREPROCESSOR-BLOCK-END */
&ANALYZE-RESUME


/* *********************** Procedure Settings ************************ */

&ANALYZE-SUSPEND _PROCEDURE-SETTINGS
/* Settings for THIS-PROCEDURE
   Type: Procedure
   Allow: 
   Frames: 0
   Add Fields to: Neither
   Other Settings: CODE-ONLY COMPILE
 */
&ANALYZE-RESUME _END-PROCEDURE-SETTINGS

/* *************************  Create Window  ************************** */

&ANALYZE-SUSPEND _CREATE-WINDOW
/* DESIGN Window definition (used by the UIB) 
  CREATE WINDOW Procedure ASSIGN
         HEIGHT             = 15
         WIDTH              = 60.
/* END WINDOW DEFINITION */
                                                                        */
&ANALYZE-RESUME

 


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _MAIN-BLOCK Procedure 


/* ***************************  Main Block  *************************** */

dataset dsRequest:read-xml( 'LONGCHAR':U, gpclRequest, 'EMPTY':U, ?, ? ). 

find first ttRequestParameters
  no-error.

if not available ttRequestParameters then
  
  return.

assign
  goPropertyFlags    =     Flags:Public
                        or Flags:Protected
                        &IF proversion >= '12.2':U &THEN
                        or Flags:Package-Protected
                        &ENDIF
                        or Flags:Private
                        &IF proversion >= '12.2':U &THEN
                        or Flags:Package-private
                        &ENDIF
                        or Flags:Static
                        or Flags:Instance
  goEventFlags       =     Flags:Public
                        or Flags:Protected
                        &IF proversion >= '12.2':U &THEN
                        or Flags:Package-Protected
                        &ENDIF
                        or Flags:Private
                        &IF proversion >= '12.2':U &THEN
                        or Flags:Package-private
                        &ENDIF
                        or Flags:Static
                        or Flags:Instance
  goMethodFlags      =     Flags:Public
                        or Flags:Protected
                        &IF proversion >= '12.2':U &THEN
                        or Flags:Package-Protected
                        &ENDIF
                        or Flags:Private
                        &IF proversion >= '12.2':U &THEN
                        or Flags:Package-private
                        &ENDIF
                        or Flags:Static
                        or Flags:Instance
  goConstructorFlags =     Flags:Public
                        or Flags:Protected
                        &IF proversion >= '12.2':U &THEN
                        or Flags:Package-Protected
                        &ENDIF
                        or Flags:Private
                        &IF proversion >= '12.2':U &THEN
                        or Flags:Package-private
                        &ENDIF
                        or Flags:Instance
  .

gcSessionLanguage = dynamic-property( 'pACConnectionSvc':U, 'prpcLanguage':U ) no-error.

if temp-table ttRequestClass:has-records then

  run addAllClassesFromFileList( ttRequestParameters.LoadDetails ).
  
else
  
  run addAllClassesFromPropath( ttRequestParameters.LoadDetails ).

dataset dsClasses:write-xml( 'longchar':U, gopclReturnValue, yes ).

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* **********************  Internal Procedures  *********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addAllClassesFromFileList Procedure
PROCEDURE addAllClassesFromFileList:
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plAddDetails as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttRequestClass for temp-table ttRequestClass.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttRequestClass
  on error undo, throw:
  
  if not bttRequestClass.ClassRelativeFilePath matches '*~.cls':U then
    
    bttRequestClass.ClassRelativeFilePath = substitute( '&1.cls':U, bttRequestClass.ClassRelativeFilePath ).
  
  run addClass( bttRequestClass.ClassRelativeFilePath, yes ).
  
  catch oError as Error :
    undo, next.
  end catch. /* Error */
  
end. /* do giClass = 1 to num-entries( gpclParameter ) */

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addAllClassesFromPath Procedure
PROCEDURE addAllClassesFromPath:
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcBasePath   as character no-undo.
define input parameter pcPath       as character no-undo.
define input parameter plAddDetails as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cFileAttributes   as character no-undo.
define variable cFileName         as character no-undo.
define variable cFilePath         as character no-undo.

define variable iBasePathLength   as integer   no-undo.
define variable cRelativeFilePath as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

iBasePathLength = length( pcBasePath ).

input from os-dir ( pcPath ) no-echo.

repeat
  on error  undo, throw:

  import cFileName cFilePath cFileAttributes.
  
  if    index( cFileAttributes, 'F':U ) > 0
    and cFileName matches( '*.cls':U ) then
    
    run addClass( substring( cFilePath, iBasePathLength + 1 ), plAddDetails ).
  
  if    index( cFileAttributes, 'D':U ) > 0
    and cFileName <> '.':U
    and cFileName <> '..':U then
      
    run addAllClassesFromPath( pcBasePath, cFilePath, plAddDetails ).
  
  catch oError as Error :
    undo, next.
  end catch. /* Error */
  
end. /* ReadFiles */

finally:
  input close.
end.

END PROCEDURE.
	
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addAllClassesFromPropath Procedure
PROCEDURE addAllClassesFromPropath:
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plAddDetails as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iPropathCounter as integer   no-undo.
define variable cPathEntry      as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

do iPropathCounter = 1 to num-entries( propath ):
  
  assign
    cPathEntry = entry( iPropathCounter, propath )
    cPathEntry = trim( cPathEntry, ' /\':U )
    cPathEntry = replace( cPathEntry, '/':U, '\':U )
    .
  
  if    not cPathEntry matches '*\src':U
    and not cPathEntry matches '*\prerel':U
    and not cPathEntry matches '*\cry':U
    and not cPathEntry matches '*\wrk':U
    and not cPathEntry matches '*\tst':U
    and not cPathEntry matches '*\test':U
    and not cPathEntry matches '*\tests':U
    and not cPathEntry matches '*\src-addon\*':U
    and not cPathEntry matches '*\dev_config':U then
    
    next.
  
  run addAllClassesFromPath( cPathEntry, cPathEntry, plAddDetails ) no-error.
  
end. /* do iPropathCounter = 1 to num-entries( propath ) */

END PROCEDURE.
	
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addClass Procedure 
PROCEDURE addClass :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcRelativeFilePath as character no-undo.
define input parameter plAddDetails       as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iPackageSeparatorIndex       as integer     no-undo.
define variable cPackageName                 as character   no-undo.
define variable cClassFilename               as character   no-undo.
define variable iFileExtensionSeparatorIndex as integer     no-undo.
define variable cClassName                   as character   no-undo.

define variable oClass                       as class Class no-undo.
define variable oSuperClass                  as class Class no-undo.
                                             
define variable oConstructors                as Constructor no-undo extent.
define variable iConstructor                 as integer     no-undo.
                                             
define variable oProperties                  as Property    no-undo extent.
define variable iProperty                    as integer     no-undo.
                                             
define variable oEvents                      as Event       no-undo extent.
define variable iEventCounter                as integer     no-undo.
                                             
define variable oMethods                     as Method      no-undo extent.
define variable iMethod                      as integer     no-undo.

define variable lInstanceExistsInRepository  as logical      no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttClass              for temp-table ttClass.
define buffer bttClassDescription   for temp-table ttClassDescription.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  pcRelativeFilePath = replace( pcRelativeFilePath, '\':U, '/':U )
  pcRelativeFilePath = trim( pcRelativeFilePath, '/':U )
  .

if can-find( first ttClass
               where ttClass.RelativeFilePath = pcRelativeFilePath ) then
  
  return.

assign
  iPackageSeparatorIndex       = r-index( pcRelativeFilePath, '/':U )
  cPackageName                 = ( if iPackageSeparatorIndex > 0 then
                                     replace( substring( pcRelativeFilePath, 1, iPackageSeparatorIndex - 1 ),
                                              '/':U,
                                              '.':U )
                                   else
                                     '':U )
  cClassFilename               = ( if iPackageSeparatorIndex > 0 then
                                     substring( pcRelativeFilePath, iPackageSeparatorIndex + 1 )
                                   else
                                     pcRelativeFilePath )
  iFileExtensionSeparatorIndex = r-index( cClassFilename, '.':U )
  cClassName                   = ( if iFileExtensionSeparatorIndex > 0 then
                                     substring( cClassFilename, 1, iFileExtensionSeparatorIndex - 1 )
                                   else
                                     cClassFilename )
  .

create bttClass.

assign
  bttClass.RelativeFilePath = pcRelativeFilePath
  bttClass.PackageName      = cPackageName
  bttClass.ClassName        = cClassName
  bttClass.ClassTypeName    = ( if cPackageName > '':U then
                                  substitute( '&1.&2':U, cPackageName, cClassName )
                                else
                                  cClassName )
  .

/* Add description. */

lInstanceExistsInRepository = dynamic-function( 'pa_lReposIsInstanceExisting':U in target-procedure,
                                                cClassFilename ) no-error.

if    not error-status:error
  and lInstanceExistsInRepository then
do:
  
  create bttClassDescription.
  
  assign
    bttClassDescription.ClassName = bttClass.ClassName
    bttClassDescription.Language  = gcSessionLanguage
    .
  
  bttClassDescription.ShortDescription = dynamic-function( 'pa_cReposInstanceInformationByName':U in target-procedure,
                                                           cClassFilename, 'ShortDesc1':U ) no-error.
  
  validate bttClassDescription.
  
end.

if plAddDetails then
Details:
do on error undo, throw:
  
  oClass = progress.lang.Class:getClass( if cPackageName > '':U then
                                           substitute( '&1.&2':U, cPackageName, cClassName )
                                         else
                                           cClassName ) no-error.
  
  if error-status:error then
  do:
    
    bttClass.DetailsError = yes.
    leave Details.
    
  end. /* if error-status:error */
  
  oSuperClass = oClass:SuperClass.
  
  if valid-object( oSuperClass ) then
    bttClass.SuperClassName = oSuperClass:TypeName.
  
  assign
    bttClass.ClassTypeName = oClass:TypeName
    bttClass.IsAbstract    = oClass:IsAbstract()
    bttClass.IsEnum        = oClass:IsEnum()
    bttClass.IsFinal       = oClass:IsFinal()
    bttClass.IsFlagsEnum   = oClass:IsFlagsEnum()
    bttClass.IsInterface   = oClass:IsInterface()
    .
  
  /* Add Properties */
  
  oProperties = oClass:GetProperties( goPropertyFlags ).
  
  do iProperty = 1 to extent( oProperties ):
    
    run addProperty( bttClass.ClassName,
                     oProperties[iProperty] ).
    
  end. /* do iProperty = 1 to extent( oProperties ) */
  
  /* Add enum values */
  
  if oClass:IsEnum() then
    
    run addEnumMembers( bttClass.ClassName, oClass ).
  
  /* Add Events */
  
  oEvents = oClass:GetEvents( goEventFlags ).
  
  do iEventCounter = 1 to extent( oEvents ):
    
    run addEvent( bttClass.ClassName,
                  oEvents[iEventCounter] ).
    
  end. /* do iMethod = 1 to extent( oMethods ) */
  
  /* Add constructors */
  
  oConstructors = oClass:GetConstructors( goConstructorFlags ).
  
  do iConstructor = 1 to extent( oConstructors ):
    
    run addConstructor( bttClass.ClassName,
                        iConstructor,
                        oConstructors[iConstructor] ).
    
  end. /* do iConstructor = 1 to extent( oConstructors ) */
  
  /* Add methods */
  
  oMethods = oClass:GetMethods( goMethodFlags ).
  
  do iMethod = 1 to extent( oMethods ):
    
    run addMethod( bttClass.ClassName,
                   iMethod,
                   oMethods[iMethod] ).
    
  end. /* do iMethod = 1 to extent( oMethods ) */
  
  finally:
    bttClass.DetailsLoaded = yes.
  end finally.
  
end. /* if plAddDetails */

validate bttClass.

end procedure. /* addClass */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addConstructor Procedure 
PROCEDURE addConstructor :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName        as character   no-undo.
define input parameter piConstructorIndex as integer     no-undo.

define input parameter poConstructor      as Constructor no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oOriginatingClass as class Class no-undo.
define variable oAccessMode       as AccessMode  no-undo.

define variable oPrameters        as Parameter   no-undo extent.
define variable iParameter        as integer     no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttConstructor for temp-table ttConstructor.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttConstructor.

assign
  bttConstructor.ClassName        = pcClassName
  bttConstructor.ConstructorIndex = piConstructorIndex
  bttConstructor.ConstructorName  = poConstructor:Name
  oOriginatingClass               = poConstructor:OriginatingClass
  oAccessMode                     = poConstructor:AccessMode
  .

if valid-object( oOriginatingClass ) then
  bttConstructor.OriginatingClass = oOriginatingClass:TypeName.

if valid-object( oAccessMode ) then
  bttConstructor.AccessMode = oAccessMode:toString().
  .

validate bttConstructor.

oPrameters = poConstructor:GetParameters().

do iParameter = 1 to extent( oPrameters ):
  
  run addConstructorParameter( bttConstructor.ClassName,
                               bttConstructor.ConstructorIndex,
                               oPrameters[iParameter] ).
  
end. /* do iParameter = 1 to extent( oPrameters ) */

end procedure. /* addConstructor */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addConstructorParameter Procedure 
PROCEDURE addConstructorParameter :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName        as character no-undo.
define input parameter piConstructorIndex as integer   no-undo.

define input parameter poParameter        as Parameter no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oDataType  as DataType      no-undo.
define variable oMode      as ParameterMode no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttConstructorParameter for temp-table ttConstructorParameter.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttConstructorParameter.

assign
  bttConstructorParameter.ClassName        = pcClassName
  bttConstructorParameter.ConstructorIndex = piConstructorIndex
  bttConstructorParameter.Position         = poParameter:Position
  bttConstructorParameter.ParameterName    = poParameter:Name
  bttConstructorParameter.DataTypeName     = poParameter:DataTypeName
  bttConstructorParameter.Extent           = poParameter:Extent
  oDataType                                = poParameter:DataType
  oMode                                    = poParameter:Mode
  .

if valid-object( oDataType ) then
  bttConstructorParameter.DataType = oDataType:toString().

if valid-object( oMode ) then
  bttConstructorParameter.Mode = oMode:toString().

validate bttConstructorParameter.

end procedure. /* addConstructorParameter */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addEnumMembers Procedure
PROCEDURE addEnumMembers:
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName as character   no-undo.
define input parameter poClass     as class Class no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cEnumNames   as character no-undo.
define variable iEnumCounter as integer   no-undo.
define variable cEnumName    as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttEnumMember for temp-table ttEnumMember.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cEnumNames = poClass:GetEnumNames().

do iEnumCounter = 1 to num-entries( cEnumNames ):
  
  cEnumName = entry( iEnumCounter, cEnumNames ).
  
  create bttEnumMember.
  
  assign
    bttEnumMember.ClassName = pcClassName
    bttEnumMember.EnumName  = cEnumName
    bttEnumMember.EnumValue = poClass:GetEnumValue( bttEnumMember.EnumName )
    .
  
  validate bttEnumMember.
  
end. /* do iEnumCounter = 1 to cEnumNames */

END PROCEDURE.
	
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addEvent Procedure 
PROCEDURE addEvent :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName   as character no-undo.
define input parameter poEvent       as Event     no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oOriginatingClass as class Class no-undo.
define variable oDeclaringClass   as class Class no-undo.
define variable oAccessMode       as AccessMode  no-undo.

define variable oPrameters        as Parameter   no-undo extent.
define variable iParameterCounter as integer     no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttEvent for temp-table ttEvent.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttEvent.

assign
  bttEvent.ClassName  = pcClassName
  bttEvent.EventName  = poEvent:Name
  bttEvent.IsStatic   = poEvent:IsStatic
  bttEvent.IsAbstract = poEvent:IsAbstract
  oDeclaringClass     = poEvent:DeclaringClass
  oOriginatingClass   = poEvent:OriginatingClass
  oAccessMode         = poEvent:AccessMode
  .

if valid-object( oDeclaringClass ) then
  bttEvent.DeclaringClass = oDeclaringClass:TypeName.

if valid-object( oOriginatingClass ) then
  bttEvent.OriginatingClass = oOriginatingClass:TypeName.

if valid-object( oAccessMode ) then
  bttEvent.AccessMode = oAccessMode:toString().
  .

validate bttEvent.

oPrameters = poEvent:GetHandlerParameters().

do iParameterCounter = 1 to extent( oPrameters ):
  
  run addEventParameter( bttEvent.ClassName,
                         bttEvent.EventName,
                         oPrameters[iParameterCounter] ).
  
end. /* do iParameterCounter = 1 to extent( oPrameters ) */

end procedure. /* addEvent */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addEventParameter Procedure 
PROCEDURE addEventParameter :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName as character no-undo.
define input parameter pcEventName as character no-undo.

define input parameter poParameter as Parameter no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oDataType  as DataType      no-undo.
define variable oMode      as ParameterMode no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttEventParameter for temp-table ttEventParameter.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttEventParameter.

assign
  bttEventParameter.ClassName     = pcClassName
  bttEventParameter.EventName     = pcEventName
  bttEventParameter.Position      = poParameter:Position
  bttEventParameter.ParameterName = poParameter:Name
  bttEventParameter.DataTypeName  = poParameter:DataTypeName
  bttEventParameter.Extent        = poParameter:Extent
  oDataType                       = poParameter:DataType
  oMode                           = poParameter:Mode
  .

if valid-object( oDataType ) then
  bttEventParameter.DataType = oDataType:toString().

if valid-object( oMode ) then
  bttEventParameter.Mode = oMode:toString().

validate bttEventParameter.

end procedure. /* addEventParameter */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addMethod Procedure 
PROCEDURE addMethod :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName   as character no-undo.
define input parameter piMethodIndex as integer   no-undo.

define input parameter poMethod      as method no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oOriginatingClass as class Class no-undo.
define variable oDeclaringClass   as class Class no-undo.
define variable oReturnType       as DataType    no-undo.
define variable oAccessMode       as AccessMode  no-undo.

define variable oPrameters        as Parameter   no-undo extent.
define variable iParameter        as integer     no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttMethod for temp-table ttMethod.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttMethod.

assign
  bttMethod.ClassName      = pcClassName
  bttMethod.MethodIndex    = piMethodIndex
  bttMethod.MethodName     = poMethod:Name
  bttMethod.IsStatic       = poMethod:IsStatic
  bttMethod.IsAbstract     = poMethod:IsAbstract
  bttMethod.IsFinal        = poMethod:IsFinal
  bttMethod.ReturnTypeName = poMethod:ReturnTypeName
  bttMethod.ReturnExtent   = poMethod:ReturnExtent
  oDeclaringClass          = poMethod:DeclaringClass
  oOriginatingClass        = poMethod:OriginatingClass
  oReturnType              = poMethod:ReturnType
  oAccessMode              = poMethod:AccessMode
  .

if valid-object( oDeclaringClass ) then
  bttMethod.DeclaringClass = oDeclaringClass:TypeName.

if valid-object( oOriginatingClass ) then
  bttMethod.OriginatingClass = oOriginatingClass:TypeName.

if valid-object( oReturnType ) then
  bttMethod.ReturnType = oReturnType:toString().

if valid-object( oAccessMode ) then
  bttMethod.AccessMode = oAccessMode:toString().
  .

validate bttMethod.

oPrameters = poMethod:GetParameters().

do iParameter = 1 to extent( oPrameters ):
  
  run addMethodParameter( bttMethod.ClassName,
                          bttMethod.MethodIndex,
                          oPrameters[iParameter] ).
  
end. /* do iParameter = 1 to extent( oPrameters ) */

end procedure. /* addMethod */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addMethodParameter Procedure 
PROCEDURE addMethodParameter :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName   as character no-undo.
define input parameter piMethodIndex as integer   no-undo.

define input parameter poParameter   as Parameter no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oDataType  as DataType      no-undo.
define variable oMode      as ParameterMode no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttMethodParameter for temp-table ttMethodParameter.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttMethodParameter.

assign
  bttMethodParameter.ClassName     = pcClassName
  bttMethodParameter.MethodIndex   = piMethodIndex
  bttMethodParameter.Position      = poParameter:Position
  bttMethodParameter.ParameterName = poParameter:Name
  bttMethodParameter.DataTypeName  = poParameter:DataTypeName
  bttMethodParameter.Extent        = poParameter:Extent
  oDataType                        = poParameter:DataType
  oMode                            = poParameter:Mode
  .

if valid-object( oDataType ) then
  bttMethodParameter.DataType = oDataType:toString().

if valid-object( oMode ) then
  bttMethodParameter.Mode = oMode:toString().

validate bttMethodParameter.

end procedure. /* addMethodParameter */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addProperty Procedure 
PROCEDURE addProperty :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcClassName   as character no-undo.

define input parameter poProperty    as property no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oDataType         as DataType    no-undo.
define variable oAccessMode       as AccessMode  no-undo.
define variable oGetterAccessMode as AccessMode  no-undo.
define variable oSetterAccessMode as AccessMode  no-undo.
define variable oOriginatingClass as class Class no-undo.
define variable oDeclaringClass   as class Class no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttProperty for temp-table ttProperty.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttProperty.

assign
  bttProperty.ClassName    = pcClassName
  bttProperty.PropertyName = poProperty:Name
  bttProperty.DataTypeName = poProperty:DataTypeName
  bttProperty.Extent       = poProperty:Extent
  bttProperty.IsStatic     = poProperty:IsStatic
  bttProperty.CanRead      = poProperty:CanRead
  bttProperty.CanWrite     = poProperty:CanWrite
  oDataType                = poProperty:DataType
  oAccessMode              = poProperty:AccessMode
  oGetterAccessMode        = poProperty:GetterAccessMode
  oSetterAccessMode        = poProperty:SetterAccessMode
  oOriginatingClass        = poProperty:OriginatingClass
  oDeclaringClass          = poProperty:DeclaringClass
  .

if valid-object ( oDataType ) then
  bttProperty.DataType = oDataType:toString().

if valid-object( oAccessMode ) then
  bttProperty.AccessMode = oAccessMode:toString().

if valid-object( oGetterAccessMode ) then
  bttProperty.GetterAccessMode = oGetterAccessMode:toString().

if valid-object( oSetterAccessMode ) then
  bttProperty.SetterAccessMode = oSetterAccessMode:toString().

if valid-object( oOriginatingClass ) then
  bttProperty.OriginatingClass = oOriginatingClass:TypeName.

if valid-object( oDeclaringClass ) then
  bttProperty.DeclaringClass = oDeclaringClass:TypeName.

validate bttProperty.

end procedure. /* addProperty */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME