/*
 * Decompiled with CFR 0.152.
 */
package selectionannotator.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;

public abstract class AnnotationModelUtilities {
    public static <T extends Annotation> Collection<T> getAnnotations(IAnnotationModel annotationModel, Class<T> annotationClass) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        Iterator annotationIterator = annotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!annotationClass.isInstance(annotation)) continue;
            annotationList.add((Annotation)annotationClass.cast(annotation));
        }
        return annotationList;
    }

    public static <T extends Annotation, U extends Position> void addAnnotations(IAnnotationModel annotationModel, Map<T, U> annotations) {
        if (annotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension annotationModelExtension = (IAnnotationModelExtension)annotationModel;
            annotationModelExtension.replaceAnnotations(null, annotations);
        } else {
            for (Map.Entry<T, U> annotation : annotations.entrySet()) {
                annotationModel.addAnnotation((Annotation)annotation.getKey(), (Position)annotation.getValue());
            }
        }
    }

    public static <T extends Annotation> void deleteAnnotations(IAnnotationModel annotationModel, Class<T> annotationClass) {
        Collection<T> annotationCollection = AnnotationModelUtilities.getAnnotations(annotationModel, annotationClass);
        AnnotationModelUtilities.deleteAnnotations(annotationModel, annotationCollection);
    }

    public static <T extends Annotation> void deleteAnnotations(IAnnotationModel annotationModel, Collection<T> annotations) {
        if (annotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension annotationModelExtension = (IAnnotationModelExtension)annotationModel;
            annotationModelExtension.replaceAnnotations(annotations.toArray(new Annotation[annotations.size()]), null);
        } else {
            for (Annotation annotation : annotations) {
                annotationModel.removeAnnotation(annotation);
            }
        }
    }

    public static <T extends Annotation, U extends Annotation, V extends Position> void replaceAnnotations(IAnnotationModel annotationModel, Collection<T> annotationsDelete, Map<U, V> annotationsAdd) {
        if (annotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension annotationModelExtension = (IAnnotationModelExtension)annotationModel;
            annotationModelExtension.replaceAnnotations(annotationsDelete.toArray(new Annotation[annotationsDelete.size()]), annotationsAdd);
        } else {
            if (annotationsDelete != null) {
                AnnotationModelUtilities.deleteAnnotations(annotationModel, annotationsDelete);
            }
            if (annotationsAdd != null) {
                AnnotationModelUtilities.addAnnotations(annotationModel, annotationsAdd);
            }
        }
    }
}

