/*
 * Decompiled with CFR 0.152.
 */
package selectionannotator.listeners;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import selectionannotator.listeners.PageListener;
import selectionannotator.listeners.PartListener;
import selectionannotator.listeners.TextEditorSelectionChangedListener;
import selectionannotator.listeners.WindowListener;

public abstract class ListenerUtilities {
    public static void addListenersToWorkbench(IWorkbench workbench) {
        workbench.addWindowListener((IWindowListener)new WindowListener());
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows == null) {
            return;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            ListenerUtilities.addListenersToWindow(window);
            ++n2;
        }
    }

    public static void addListenersToWindow(IWorkbenchWindow window) {
        window.addPageListener((IPageListener)new PageListener());
        IWorkbenchPage[] pages = window.getPages();
        if (pages == null) {
            return;
        }
        IWorkbenchPage[] iWorkbenchPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            ListenerUtilities.addListenersToPage(page);
            ++n2;
        }
    }

    public static void addListenersToPage(IWorkbenchPage page) {
        page.addPartListener((IPartListener)new PartListener());
        IEditorReference[] editorReferences = page.getEditorReferences();
        if (editorReferences == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(false);
            if (editorPart instanceof ITextEditor) {
                ListenerUtilities.addListenersToTextEditor((ITextEditor)editorPart);
            }
            ++n2;
        }
    }

    public static void addListenersToTextEditor(ITextEditor textEditor) {
        textEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)new TextEditorSelectionChangedListener(textEditor));
    }
}

